/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import javax.naming.NamingException;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.Assert;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.security.auth.AuthenticationException;
import org.xnio.IoFuture;

final class AggregateRemoteNamingProvider
extends RemoteNamingProvider {
    private final RemoteNamingProvider[] remoteNamingProviders;
    private volatile int currentProvider;

    AggregateRemoteNamingProvider(RemoteNamingProvider ... remoteNamingProviders) {
        Assert.checkNotNullParam("remoteNamingProviders", remoteNamingProviders);
        this.remoteNamingProviders = (RemoteNamingProvider[])remoteNamingProviders.clone();
    }

    AggregateRemoteNamingProvider(Collection<RemoteNamingProvider> remoteNamingProviders) {
        Assert.checkNotNullParam("remoteNamingProviders", remoteNamingProviders);
        this.remoteNamingProviders = remoteNamingProviders.toArray(new RemoteNamingProvider[remoteNamingProviders.size()]);
    }

    @Override
    public Endpoint getEndpoint() {
        return this.getCurrentProvider().getEndpoint();
    }

    @Override
    public synchronized ConnectionPeerIdentity getPeerIdentity() throws AuthenticationException, IOException {
        int startingProvider;
        int nextProvider = startingProvider = this.currentProvider;
        IOException e = null;
        while (true) {
            try {
                ConnectionPeerIdentity peerIdentity = this.remoteNamingProviders[nextProvider].getPeerIdentity();
                this.currentProvider = nextProvider;
                return peerIdentity;
            }
            catch (IOException reason) {
                if (e == null) {
                    e = Messages.log.failedToConnectToAnyServer();
                }
                e.addSuppressed(reason);
                if ((nextProvider = (nextProvider + 1) % this.remoteNamingProviders.length) != startingProvider) continue;
                assert (e != null);
                throw e;
            }
            break;
        }
    }

    @Override
    public IoFuture<ConnectionPeerIdentity> getFuturePeerIdentity() {
        return this.getCurrentProvider().getFuturePeerIdentity();
    }

    @Override
    public URI getProviderUri() {
        return this.getCurrentProvider().getProviderUri();
    }

    @Override
    public void close() throws NamingException {
        boolean exceptionOnClose = false;
        for (RemoteNamingProvider remoteNamingProvider : this.remoteNamingProviders) {
            try {
                remoteNamingProvider.close();
            }
            catch (NamingException e) {
                exceptionOnClose = true;
            }
        }
        if (exceptionOnClose) {
            throw Messages.log.failedToCloseNamingProviders();
        }
    }

    private RemoteNamingProvider getCurrentProvider() {
        return this.remoteNamingProviders[this.currentProvider];
    }
}

