/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.impl.BasicAuthenticationMechanism;
import org.wildfly.security.http.impl.ClientCertAuthenticationMechanism;
import org.wildfly.security.http.impl.DigestAuthenticationMechanism;
import org.wildfly.security.http.impl.FormAuthenticationMechanism;
import org.wildfly.security.http.impl.NonceManager;
import org.wildfly.security.http.impl.SpnegoAuthenticationMechanism;

public class ServerMechanismFactoryImpl
implements HttpServerAuthenticationMechanismFactory {
    private final Supplier<Provider[]> providers;
    private static NonceManager nonceManager = new NonceManager(60000L, true, 20, "SHA-256");

    public ServerMechanismFactoryImpl() {
        this.providers = Security::getProviders;
    }

    public ServerMechanismFactoryImpl(Provider provider) {
        this.providers = () -> new Provider[]{provider};
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        ArrayList<String> mechanismNames = new ArrayList<String>();
        mechanismNames.add("BASIC");
        mechanismNames.add("CLIENT_CERT");
        mechanismNames.add("DIGEST");
        mechanismNames.add("FORM");
        mechanismNames.add("SPNEGO");
        return mechanismNames.toArray(new String[mechanismNames.size()]);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        Assert.checkNotNullParam("mechanismName", mechanismName);
        Assert.checkNotNullParam("properties", properties);
        Assert.checkNotNullParam("callbackHandler", callbackHandler);
        switch (mechanismName) {
            case "BASIC": {
                return new BasicAuthenticationMechanism(callbackHandler, (String)properties.get(HttpConstants.CONFIG_REALM), false);
            }
            case "CLIENT_CERT": {
                return new ClientCertAuthenticationMechanism(callbackHandler);
            }
            case "DIGEST": {
                return new DigestAuthenticationMechanism(callbackHandler, nonceManager, (String)properties.get(HttpConstants.CONFIG_REALM), (String)properties.get(HttpConstants.CONFIG_CONTEXT_PATH), this.providers);
            }
            case "FORM": {
                return new FormAuthenticationMechanism(callbackHandler, properties);
            }
            case "SPNEGO": {
                return new SpnegoAuthenticationMechanism(callbackHandler, properties);
            }
        }
        return null;
    }
}

