/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import javax.net.ssl.SSLContext;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptorInformation;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverSessionCreationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

public final class EJBSessionCreationInvocationContext
extends AbstractInvocationContext {
    private final AuthenticationConfiguration authenticationConfiguration;
    private final SSLContext sslContext;
    private final EJBClientContext.InterceptorList interceptorList;
    private int interceptorChainIndex;

    EJBSessionCreationInvocationContext(StatelessEJBLocator<?> locator, EJBClientContext ejbClientContext, AuthenticationConfiguration authenticationConfiguration, SSLContext sslContext, EJBClientContext.InterceptorList interceptorList) {
        super(locator, ejbClientContext);
        this.authenticationConfiguration = authenticationConfiguration;
        this.sslContext = sslContext;
        this.interceptorList = interceptorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionID proceed() throws Exception {
        int idx = this.interceptorChainIndex++;
        try {
            EJBClientInterceptorInformation[] chain = this.interceptorList.getInformation();
            if (idx > chain.length) {
                throw Assert.unreachableCode();
            }
            if (chain.length == idx) {
                URI destination = this.getDestination();
                EJBReceiver receiver = this.getClientContext().resolveReceiver(destination, this.getLocator());
                this.setReceiver(receiver);
                SessionID sessionID = receiver.createSession(new EJBReceiverSessionCreationContext(this, this.authenticationConfiguration, this.sslContext));
                if (sessionID == null) {
                    throw Logs.INVOCATION.nullSessionID(receiver, this.getLocator().asStateless());
                }
                SessionID sessionID2 = sessionID;
                return sessionID2;
            }
            SessionID sessionID = chain[idx].getInterceptorInstance().handleSessionCreation(this);
            return sessionID;
        }
        finally {
            --this.interceptorChainIndex;
        }
    }

    @Override
    public void requestRetry() {
    }
}

