/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.wildfly.common.Assert;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;

public final class RemoteTransaction
extends AbstractTransaction {
    private final AtomicReference<State> stateRef;
    private final ConcurrentMap<Object, Object> resources = new ConcurrentHashMap<Object, Object>();
    private final URI location;
    private final Object key = new Key();
    private final SimpleTransactionControl control;
    private final int timeout;

    RemoteTransaction(SimpleTransactionControl control, URI location, int timeout) {
        this.stateRef = new AtomicReference<Active>(new Active());
        this.location = location;
        this.control = control;
        this.timeout = timeout;
    }

    @Override
    Object getResource(Object key) throws NullPointerException {
        Assert.checkNotNullParamWithNullPointerException("key", key);
        return this.resources.get(key);
    }

    @Override
    void putResource(Object key, Object value) throws NullPointerException {
        Assert.checkNotNullParamWithNullPointerException("key", key);
        if (value == null) {
            this.resources.remove(key);
        } else {
            this.resources.put(key, value);
        }
    }

    @Override
    Object getKey() {
        return this.key;
    }

    @Override
    void suspend() {
        this.notifyAssociationListeners(false);
    }

    @Override
    void resume() {
        this.notifyAssociationListeners(true);
    }

    @Override
    void verifyAssociation() {
    }

    @Override
    public int getTransactionTimeout() {
        return this.timeout;
    }

    @Override
    public <T> T getProviderInterface(Class<T> providerInterfaceType) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(TransactionPermission.forName("getProviderInterface"));
        }
        return this.control.getProviderInterface(providerInterfaceType);
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        this.stateRef.get().commit();
    }

    @Override
    void commitAndDissociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        try {
            this.commit();
        }
        finally {
            this.suspend();
        }
    }

    @Override
    public void rollback() throws IllegalStateException, SystemException {
        this.stateRef.get().rollback();
    }

    @Override
    void rollbackAndDissociate() throws IllegalStateException, SystemException {
        try {
            this.rollback();
        }
        finally {
            this.suspend();
        }
    }

    @Override
    boolean importBacking() {
        return false;
    }

    @Override
    void unimportBacking() {
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.stateRef.get().setRollbackOnly();
    }

    @Override
    public int getStatus() {
        return this.stateRef.get().getStatus();
    }

    @Override
    public boolean enlistResource(XAResource xaRes) {
        Assert.checkNotNullParam("xaRes", xaRes);
        return false;
    }

    @Override
    public boolean delistResource(XAResource xaRes, int flag) {
        Assert.checkNotNullParam("xaRes", xaRes);
        return false;
    }

    @Override
    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        Assert.checkNotNullParam("sync", sync);
        this.stateRef.get().registerSynchronization(new AbstractTransaction.AssociatingSynchronization(sync));
    }

    @Override
    void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        Assert.checkNotNullParam("sync", sync);
        this.stateRef.get().registerInterposedSynchronization(new AbstractTransaction.AssociatingSynchronization(sync));
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return String.format("Remote transaction \"%s\" (delegate=%s)", this.location, this.control);
    }

    public URI getLocation() {
        return this.location;
    }

    class Key {
        Key() {
        }

        public int hashCode() {
            return RemoteTransaction.this.location.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Key && this.equals((Key)obj);
        }

        private boolean equals(Key key) {
            return RemoteTransaction.this.location.equals(key.getLocation());
        }

        private URI getLocation() {
            return RemoteTransaction.this.location;
        }
    }

    static final class InactiveState
    extends State {
        private final int status;
        static final InactiveState ROLLED_BACK = new InactiveState(4);
        static final InactiveState COMMITTED = new InactiveState(3);
        static final InactiveState UNKNOWN = new InactiveState(5);
        static final InactiveState COMMITTING = new InactiveState(8);
        static final InactiveState ROLLING_BACK = new InactiveState(9);

        private InactiveState(int status) {
            this.status = status;
        }

        @Override
        void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
            throw Log.log.notActive();
        }

        @Override
        void rollback() throws IllegalStateException, SystemException {
            throw Log.log.notActive();
        }

        @Override
        void setRollbackOnly() throws IllegalStateException, SystemException {
            if (this.status != 9) {
                throw Log.log.notActive();
            }
        }

        @Override
        int getStatus() {
            return this.status;
        }

        @Override
        void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
            throw Log.log.notActive();
        }

        @Override
        void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
            throw Log.log.notActive();
        }
    }

    final class RollbackOnly
    extends Unresolved {
        RollbackOnly() {
        }

        @Override
        void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
            this.rollback();
            throw Log.log.rollbackOnlyRollback();
        }

        @Override
        void setRollbackOnly() {
        }

        @Override
        int getStatus() {
            return 1;
        }

        @Override
        void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
            throw Log.log.markedRollbackOnly();
        }
    }

    final class Active
    extends Unresolved {
        Active() {
        }

        @Override
        void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
            AtomicReference stateRef = RemoteTransaction.this.stateRef;
            if (!stateRef.compareAndSet(this, InactiveState.COMMITTING)) {
                ((State)stateRef.get()).commit();
                return;
            }
            try {
                RemoteTransaction.this.control.commit();
            }
            catch (SecurityException e) {
                stateRef.set(this);
                throw e;
            }
            catch (HeuristicRollbackException | RollbackException e) {
                stateRef.set(InactiveState.ROLLED_BACK);
                throw e;
            }
            catch (Throwable t) {
                stateRef.set(InactiveState.UNKNOWN);
                throw t;
            }
            stateRef.set(InactiveState.COMMITTED);
        }

        @Override
        int getStatus() {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setRollbackOnly() throws IllegalStateException, SystemException {
            AtomicReference stateRef;
            AtomicReference atomicReference = stateRef = RemoteTransaction.this.stateRef;
            synchronized (atomicReference) {
                RollbackOnly newState = new RollbackOnly();
                if (!stateRef.compareAndSet(this, newState)) {
                    ((State)stateRef.get()).setRollbackOnly();
                }
                RemoteTransaction.this.control.setRollbackOnly();
            }
        }
    }

    abstract class Unresolved
    extends State {
        Unresolved() {
        }

        @Override
        void rollback() throws IllegalStateException, SystemException {
            AtomicReference stateRef = RemoteTransaction.this.stateRef;
            if (!stateRef.compareAndSet(this, InactiveState.ROLLING_BACK)) {
                ((State)stateRef.get()).rollback();
                return;
            }
            try {
                RemoteTransaction.this.control.rollback();
            }
            catch (SecurityException e) {
                stateRef.set(this);
                throw e;
            }
            catch (Throwable t) {
                stateRef.set(InactiveState.UNKNOWN);
                throw t;
            }
            stateRef.set(InactiveState.ROLLED_BACK);
        }

        @Override
        void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
            throw Log.log.registerSynchRemoteTransaction();
        }

        @Override
        void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
            throw Log.log.registerSynchRemoteTransaction();
        }
    }

    static abstract class State {
        State() {
        }

        abstract void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException;

        abstract void rollback() throws IllegalStateException, SystemException;

        abstract void setRollbackOnly() throws IllegalStateException, SystemException;

        abstract int getStatus();

        abstract void registerSynchronization(Synchronization var1) throws RollbackException, IllegalStateException, SystemException;

        abstract void registerInterposedSynchronization(Synchronization var1) throws IllegalStateException;
    }
}

