/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.legacy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.common.expression.Expression;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.util.CodePointIterator;
import org.xnio.OptionMap;
import org.xnio.Options;

public final class JBossEJBProperties
implements Contextual<JBossEJBProperties> {
    public static final String DEFAULT_PATH_NAME = "jboss-ejb-client.properties";
    private static final ContextManager<JBossEJBProperties> CONTEXT_MANAGER = new ContextManager<JBossEJBProperties>(JBossEJBProperties.class, "org.jboss.ejb.client.legacy-properties");
    private static final Supplier<JBossEJBProperties> SUPPLIER = AccessController.doPrivileged(CONTEXT_MANAGER::getPrivilegedSupplier);
    private static final String PROPERTY_KEY_ENDPOINT_NAME = "endpoint.name";
    private static final String DEFAULT_ENDPOINT_NAME = "config-based-ejb-client-endpoint";
    private static final String PROPERTY_KEY_INVOCATION_TIMEOUT = "invocation.timeout";
    private static final String PROPERTY_KEY_RECONNECT_TASKS_TIMEOUT = "reconnect.tasks.timeout";
    private static final String PROPERTY_KEY_DEPLOYMENT_NODE_SELECTOR = "deployment.node.selector";
    private static final String ENDPOINT_CREATION_OPTIONS_PREFIX = "endpoint.create.options.";
    private static final OptionMap DEFAULT_ENDPOINT_CREATION_OPTIONS = OptionMap.create(Options.THREAD_DAEMON, Boolean.TRUE);
    private static final OptionMap DEFAULT_CONNECTION_PROVIDER_CREATION_OPTIONS = OptionMap.EMPTY;
    private static final String REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX = "remote.connectionprovider.create.options.";
    private static final String PROPERTY_KEY_REMOTE_CONNECTIONS = "remote.connections";
    private static final String PROPERTY_KEY_REMOTE_CONNECTIONS_CONNECT_EAGER = "remote.connections.connect.eager";
    private static final OptionMap DEFAULT_CONNECTION_CREATION_OPTIONS = OptionMap.EMPTY;
    private static final long DEFAULT_CONNECTION_TIMEOUT_IN_MILLIS = 5000L;
    private static final String PROPERTY_KEY_USERNAME = "username";
    private static final String PROPERTY_KEY_PASSWORD = "password";
    private static final String PROPERTY_KEY_PASSWORD_BASE64 = "password.base64";
    private static final String PROPERTY_KEY_REALM = "realm";
    private static final String PROPERTY_KEY_CALLBACK_HANDLER_CLASS = "callback.handler.class";
    private static final String PROPERTY_KEY_HOST = "host";
    private static final String PROPERTY_KEY_PORT = "port";
    private static final String PROPERTY_KEY_PROTOCOL = "protocol";
    private static final String DEFAULT_PROTOCOL = "http-remoting";
    private static final String PROPERTY_KEY_CLUSTERS = "remote.clusters";
    private static final boolean expandPasswords = AccessController.doPrivileged(() -> Boolean.valueOf(System.getProperty("jboss-ejb-client.expandPasswords", "false")));
    private static final String CONFIGURED_PATH_NAME;
    private final String endpointName;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final String defaultCallbackHandlerClassName;
    private final OptionMap endpointCreationOptions;
    private final OptionMap remoteConnectionProviderCreationOptions;
    private final List<ConnectionConfiguration> connectionList;
    private final ExceptionSupplier<CallbackHandler, ReflectiveOperationException> callbackHandlerSupplier;
    private final ExceptionSupplier<DeploymentNodeSelector, ReflectiveOperationException> deploymentNodeSelectorSupplier;
    private final Map<String, ClusterConfiguration> clusterConfigurations;
    private final long invocationTimeout;
    private final long reconnectTimeout;
    private final String deploymentNodeSelectorClassName;
    private final boolean defaultConnectEagerly;

    JBossEJBProperties(Builder builder) {
        this.endpointName = builder.endpointName;
        this.defaultCallbackHandlerClassName = builder.callbackHandlerClassName;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.endpointCreationOptions = builder.endpointCreationOptions;
        this.remoteConnectionProviderCreationOptions = builder.remoteConnectionProviderCreationOptions;
        this.callbackHandlerSupplier = builder.callbackHandlerSupplier;
        this.deploymentNodeSelectorSupplier = builder.deploymentNodeSelectorSupplier;
        this.clusterConfigurations = builder.clusterConfigurations;
        this.invocationTimeout = builder.invocationTimeout;
        this.reconnectTimeout = builder.reconnectTimeout;
        this.deploymentNodeSelectorClassName = builder.deploymentNodeSelectorClassName;
        this.connectionList = builder.connectionList;
        this.defaultConnectEagerly = builder.connectEagerly;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public String getDefaultCallbackHandlerClassName() {
        return this.defaultCallbackHandlerClassName;
    }

    public AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public OptionMap getEndpointCreationOptions() {
        return this.endpointCreationOptions;
    }

    public OptionMap getRemoteConnectionProviderCreationOptions() {
        return this.remoteConnectionProviderCreationOptions;
    }

    public List<ConnectionConfiguration> getConnectionList() {
        return this.connectionList;
    }

    public ExceptionSupplier<CallbackHandler, ReflectiveOperationException> getDefaultCallbackHandlerSupplier() {
        return this.callbackHandlerSupplier;
    }

    public ExceptionSupplier<DeploymentNodeSelector, ReflectiveOperationException> getDeploymentNodeSelectorSupplier() {
        return this.deploymentNodeSelectorSupplier;
    }

    public Map<String, ClusterConfiguration> getClusterConfigurations() {
        return this.clusterConfigurations;
    }

    public long getInvocationTimeout() {
        return this.invocationTimeout;
    }

    public long getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public String getDeploymentNodeSelectorClassName() {
        return this.deploymentNodeSelectorClassName;
    }

    public boolean isDefaultConnectEagerly() {
        return this.defaultConnectEagerly;
    }

    @Override
    @NotNull
    public ContextManager<JBossEJBProperties> getInstanceContextManager() {
        return JBossEJBProperties.getContextManager();
    }

    @NotNull
    public static ContextManager<JBossEJBProperties> getContextManager() {
        return CONTEXT_MANAGER;
    }

    private static OptionMap getOptionMapFromProperties(Properties properties, String propertyPrefix, ClassLoader classLoader) {
        return OptionMap.builder().parseAll(properties, propertyPrefix, classLoader).getMap();
    }

    private static long getLongValueFromProperties(Properties properties, String propertyName, long defVal) {
        String str = JBossEJBProperties.getProperty(properties, propertyName, null, true);
        if (str == null) {
            return defVal;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    private static String getProperty(Properties properties, String propertyName, String defaultValue, boolean expand) {
        String str = properties.getProperty(propertyName);
        if (str == null) {
            return defaultValue;
        }
        if (expand) {
            Expression expression = Expression.compile(str, Expression.Flag.LENIENT_SYNTAX);
            return expression.evaluateWithPropertiesAndEnvironment(false);
        }
        return str.trim();
    }

    public static JBossEJBProperties fromProperties(String fileName, Properties properties) {
        Map<String, ClusterConfiguration> clusterMap;
        List<ConnectionConfiguration> connectionList;
        String connectionsString;
        Assert.checkNotNullParam("fileName", fileName);
        Assert.checkNotNullParam("properties", properties);
        ClassLoader classLoader = JBossEJBProperties.class.getClassLoader();
        Builder builder = new Builder();
        builder.populateFromProperties(properties, "", classLoader, null);
        builder.setEndpointName(JBossEJBProperties.getProperty(properties, PROPERTY_KEY_ENDPOINT_NAME, null, true));
        String defaultCallbackHandlerClassName = JBossEJBProperties.getProperty(properties, PROPERTY_KEY_CALLBACK_HANDLER_CLASS, null, true);
        builder.setCallbackHandlerClassName(defaultCallbackHandlerClassName);
        builder.setCallbackHandlerSupplier(() -> Class.forName(defaultCallbackHandlerClassName, true, classLoader).asSubclass(CallbackHandler.class).getConstructor(new Class[0]).newInstance(new Object[0]));
        builder.setEndpointCreationOptions(JBossEJBProperties.getOptionMapFromProperties(properties, ENDPOINT_CREATION_OPTIONS_PREFIX, classLoader));
        builder.setRemoteConnectionProviderCreationOptions(JBossEJBProperties.getOptionMapFromProperties(properties, REMOTE_CONNECTION_PROVIDER_CREATE_OPTIONS_PREFIX, classLoader));
        builder.setInvocationTimeout(JBossEJBProperties.getLongValueFromProperties(properties, PROPERTY_KEY_INVOCATION_TIMEOUT, -1L));
        builder.setReconnectTimeout(JBossEJBProperties.getLongValueFromProperties(properties, PROPERTY_KEY_RECONNECT_TASKS_TIMEOUT, -1L));
        String deploymentNodeSelectorClassName = JBossEJBProperties.getProperty(properties, PROPERTY_KEY_DEPLOYMENT_NODE_SELECTOR, null, true);
        if (deploymentNodeSelectorClassName != null) {
            builder.setDeploymentNodeSelectorClassName(deploymentNodeSelectorClassName);
            builder.setDeploymentNodeSelectorSupplier(() -> Class.forName(deploymentNodeSelectorClassName, true, classLoader).asSubclass(DeploymentNodeSelector.class).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        if (!(connectionsString = JBossEJBProperties.getProperty(properties, PROPERTY_KEY_REMOTE_CONNECTIONS, "", true).trim()).isEmpty()) {
            ArrayList<ConnectionConfiguration> mutableList = new ArrayList<ConnectionConfiguration>();
            StringTokenizer tokenizer = new StringTokenizer(connectionsString, ",");
            while (tokenizer.hasMoreTokens()) {
                String prefix;
                ConnectionConfiguration.Builder connBuilder;
                String connectionName = tokenizer.nextToken().trim();
                if (connectionName.isEmpty() || !(connBuilder = new ConnectionConfiguration.Builder()).populateFromProperties(properties, prefix = "remote.connection." + connectionName + ".", classLoader, builder, connectionName)) continue;
                mutableList.add(new ConnectionConfiguration(connBuilder));
            }
            if (mutableList.isEmpty()) {
                connectionList = Collections.emptyList();
            } else {
                mutableList.trimToSize();
                connectionList = Collections.unmodifiableList(mutableList);
            }
        } else {
            connectionList = Collections.emptyList();
        }
        builder.setConnectionList(connectionList);
        String clustersString = JBossEJBProperties.getProperty(properties, PROPERTY_KEY_CLUSTERS, "", true).trim();
        if (!clustersString.isEmpty()) {
            HashMap<String, ClusterConfiguration> map = new HashMap<String, ClusterConfiguration>();
            StringTokenizer tokenizer = new StringTokenizer(clustersString, ",");
            while (tokenizer.hasMoreTokens()) {
                String clusterName = tokenizer.nextToken().trim();
                if (clusterName.isEmpty()) continue;
                String prefix = "remote.cluster." + clusterName + ".";
                ClusterConfiguration.Builder clusterBuilder = new ClusterConfiguration.Builder();
                clusterBuilder.populateFromProperties(clusterName, properties, prefix, classLoader, builder);
                map.put(clusterName, new ClusterConfiguration(clusterBuilder));
            }
            clusterMap = map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map);
        } else {
            clusterMap = Collections.emptyMap();
        }
        builder.setClusterConfigurations(clusterMap);
        return new JBossEJBProperties(builder);
    }

    /*
     * Exception decompiling
     */
    public static <T, U> JBossEJBProperties fromResource(String fileName, ExceptionBiFunction<T, U, InputStream, IOException> streamSupplier, T param1, U param2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> JBossEJBProperties fromResource(String fileName, ExceptionFunction<T, InputStream, IOException> streamSupplier, T param) throws IOException {
        return JBossEJBProperties.fromResource(fileName, ExceptionFunction::apply, streamSupplier, param);
    }

    public static JBossEJBProperties fromResource(String fileName, ExceptionSupplier<InputStream, IOException> streamSupplier) throws IOException {
        return JBossEJBProperties.fromResource(fileName, ExceptionSupplier::get, streamSupplier);
    }

    public static JBossEJBProperties fromFile(File propertiesFile) throws IOException {
        Assert.checkNotNullParam("propertiesFile", propertiesFile);
        return JBossEJBProperties.fromResource(propertiesFile.getPath(), FileInputStream::new, propertiesFile);
    }

    public static JBossEJBProperties fromPath(Path propertiesFile) throws IOException {
        Assert.checkNotNullParam("propertiesFile", propertiesFile);
        return JBossEJBProperties.fromResource(propertiesFile.toString(), x$0 -> Files.newInputStream(x$0, new OpenOption[0]), propertiesFile);
    }

    public static JBossEJBProperties fromClassPath(ClassLoader classLoader, String pathName) throws IOException {
        return JBossEJBProperties.fromResource(pathName, ClassLoader::getResourceAsStream, classLoader, pathName);
    }

    public static JBossEJBProperties fromClassPath() throws IOException {
        return JBossEJBProperties.fromClassPath(JBossEJBProperties.class.getClassLoader(), DEFAULT_PATH_NAME);
    }

    static JBossEJBProperties getCurrent() {
        return SUPPLIER.get();
    }

    static {
        String filePathPropertyName = "jboss.ejb.client.properties.file.path";
        CONFIGURED_PATH_NAME = AccessController.doPrivileged(() -> System.getProperty("jboss.ejb.client.properties.file.path"));
        AtomicReference onceRef = new AtomicReference();
        CONTEXT_MANAGER.setGlobalDefaultSupplier(() -> {
            JBossEJBProperties value = (JBossEJBProperties)onceRef.get();
            if (value == null) {
                AtomicReference atomicReference = onceRef;
                synchronized (atomicReference) {
                    value = (JBossEJBProperties)onceRef.get();
                    if (value == null) {
                        try {
                            if (CONFIGURED_PATH_NAME != null) {
                                try {
                                    File propertiesFile = new File(CONFIGURED_PATH_NAME);
                                    if (!propertiesFile.isAbsolute()) {
                                        propertiesFile = new File(System.getProperty("user.dir"), propertiesFile.toString());
                                    }
                                    value = JBossEJBProperties.fromFile(propertiesFile);
                                }
                                catch (IOException e) {
                                    Logs.MAIN.failedToFindEjbClientConfigFileSpecifiedBySysProp("jboss.ejb.client.properties.file.path", e);
                                    value = JBossEJBProperties.fromClassPath();
                                }
                            } else {
                                value = JBossEJBProperties.fromClassPath();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        onceRef.set(value);
                    }
                }
            }
            return value;
        });
    }

    public static final class AuthenticationConfiguration {
        private final String userName;
        private final String password;
        private final String mechanismRealm;
        private final String callbackHandlerClassName;
        private final ExceptionSupplier<CallbackHandler, ReflectiveOperationException> callbackHandlerSupplier;

        AuthenticationConfiguration(Builder builder) {
            this.userName = builder.userName;
            this.password = builder.password;
            this.mechanismRealm = builder.mechanismRealm;
            this.callbackHandlerClassName = builder.callbackHandlerClassName;
            this.callbackHandlerSupplier = builder.callbackHandlerSupplier;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public String getMechanismRealm() {
            return this.mechanismRealm;
        }

        public String getCallbackHandlerClassName() {
            return this.callbackHandlerClassName;
        }

        public ExceptionSupplier<CallbackHandler, ReflectiveOperationException> getCallbackHandlerSupplier() {
            return this.callbackHandlerSupplier;
        }

        static final class Builder {
            String userName;
            String password;
            String mechanismRealm;
            String callbackHandlerClassName;
            ExceptionSupplier<CallbackHandler, ReflectiveOperationException> callbackHandlerSupplier;

            Builder() {
            }

            Builder setUserName(String userName) {
                this.userName = userName;
                return this;
            }

            Builder setPassword(String password) {
                this.password = password;
                return this;
            }

            Builder setMechanismRealm(String mechanismRealm) {
                this.mechanismRealm = mechanismRealm;
                return this;
            }

            Builder setCallbackHandlerClassName(String callbackHandlerClassName) {
                this.callbackHandlerClassName = callbackHandlerClassName;
                return this;
            }

            Builder setCallbackHandlerSupplier(ExceptionSupplier<CallbackHandler, ReflectiveOperationException> callbackHandlerSupplier) {
                this.callbackHandlerSupplier = callbackHandlerSupplier;
                return this;
            }

            boolean populateFromProperties(Properties properties, String prefix, ClassLoader classLoader) {
                String b64Password;
                String mechanismRealm;
                String userName = JBossEJBProperties.getProperty(properties, prefix + JBossEJBProperties.PROPERTY_KEY_USERNAME, null, true);
                if (userName != null) {
                    this.setUserName(userName);
                }
                if ((mechanismRealm = JBossEJBProperties.getProperty(properties, prefix + JBossEJBProperties.PROPERTY_KEY_REALM, null, true)) != null) {
                    this.setMechanismRealm(mechanismRealm);
                }
                if ((b64Password = JBossEJBProperties.getProperty(properties, prefix + JBossEJBProperties.PROPERTY_KEY_PASSWORD_BASE64, null, expandPasswords)) != null) {
                    this.setPassword(CodePointIterator.ofString(b64Password).base64Decode().asUtf8String().drainToString());
                } else {
                    String password = JBossEJBProperties.getProperty(properties, prefix + JBossEJBProperties.PROPERTY_KEY_PASSWORD, null, expandPasswords);
                    if (password != null) {
                        this.setPassword(password);
                    } else {
                        String callbackHandlerClassName = JBossEJBProperties.getProperty(properties, prefix + JBossEJBProperties.PROPERTY_KEY_CALLBACK_HANDLER_CLASS, null, true);
                        if (callbackHandlerClassName != null) {
                            this.setCallbackHandlerClassName(callbackHandlerClassName);
                            this.setCallbackHandlerSupplier(() -> Class.forName(callbackHandlerClassName, true, classLoader).asSubclass(CallbackHandler.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                        } else if (userName == null) {
                            return false;
                        }
                    }
                }
                return true;
            }
        }
    }

    public static final class ClusterNodeConfiguration
    extends CommonSubconfiguration {
        private final String nodeName;

        ClusterNodeConfiguration(Builder builder) {
            super(builder);
            this.nodeName = builder.nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        static final class Builder
        extends CommonSubconfiguration.Builder {
            String nodeName;

            Builder() {
            }

            Builder setNodeName(String nodeName) {
                this.nodeName = nodeName;
                return this;
            }
        }
    }

    public static class ClusterConfiguration
    extends CommonSubconfiguration {
        private final String clusterName;
        private final long maximumAllowedConnectedNodes;
        private final String clusterNodeSelectorClassName;
        private final ExceptionSupplier<ClusterNodeSelector, ReflectiveOperationException> clusterNodeSelectorSupplier;
        private final List<ClusterNodeConfiguration> nodeConfigurations;

        ClusterConfiguration(Builder builder) {
            super(builder);
            this.clusterName = builder.clusterName;
            this.maximumAllowedConnectedNodes = builder.maximumAllowedConnectedNodes;
            this.clusterNodeSelectorClassName = builder.clusterNodeSelectorClassName;
            this.clusterNodeSelectorSupplier = builder.clusterNodeSelectorSupplier;
            this.nodeConfigurations = builder.nodeConfigurations;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public long getMaximumAllowedConnectedNodes() {
            return this.maximumAllowedConnectedNodes;
        }

        public String getClusterNodeSelectorClassName() {
            return this.clusterNodeSelectorClassName;
        }

        public ExceptionSupplier<ClusterNodeSelector, ReflectiveOperationException> getClusterNodeSelectorSupplier() {
            return this.clusterNodeSelectorSupplier;
        }

        public List<ClusterNodeConfiguration> getNodeConfigurations() {
            return this.nodeConfigurations;
        }

        static final class Builder
        extends CommonSubconfiguration.Builder {
            String clusterName;
            long maximumAllowedConnectedNodes;
            String clusterNodeSelectorClassName;
            ExceptionSupplier<ClusterNodeSelector, ReflectiveOperationException> clusterNodeSelectorSupplier;
            List<ClusterNodeConfiguration> nodeConfigurations = new ArrayList<ClusterNodeConfiguration>();

            Builder() {
            }

            Builder setClusterName(String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            Builder setMaximumAllowedConnectedNodes(long maximumAllowedConnectedNodes) {
                this.maximumAllowedConnectedNodes = maximumAllowedConnectedNodes;
                return this;
            }

            Builder setClusterNodeSelectorClassName(String clusterNodeSelectorClassName) {
                this.clusterNodeSelectorClassName = clusterNodeSelectorClassName;
                return this;
            }

            Builder setClusterNodeSelectorSupplier(ExceptionSupplier<ClusterNodeSelector, ReflectiveOperationException> clusterNodeSelectorSupplier) {
                this.clusterNodeSelectorSupplier = clusterNodeSelectorSupplier;
                return this;
            }

            Builder setNodeConfigurations(List<ClusterNodeConfiguration> nodeConfigurations) {
                this.nodeConfigurations = nodeConfigurations;
                return this;
            }

            boolean populateFromProperties(String clusterName, Properties properties, String prefix, ClassLoader classLoader, CommonSubconfiguration.Builder defaultsBuilder) {
                if (!super.populateFromProperties(properties, prefix, classLoader, defaultsBuilder)) {
                    return false;
                }
                if (clusterName == null) {
                    return false;
                }
                this.setClusterName(clusterName);
                this.setMaximumAllowedConnectedNodes(JBossEJBProperties.getLongValueFromProperties(properties, prefix + "max-allowed-connected-nodes", 1000L));
                String clusterNodeSelectorClassName = JBossEJBProperties.getProperty(properties, prefix + "clusternode.selector", null, true);
                if (clusterNodeSelectorClassName != null) {
                    this.setClusterNodeSelectorClassName(clusterNodeSelectorClassName);
                    this.setClusterNodeSelectorSupplier(() -> Class.forName(clusterNodeSelectorClassName, true, classLoader).asSubclass(ClusterNodeSelector.class).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                HashSet<String> nodeNames = new HashSet<String>();
                String nodePrefix = prefix + "node" + ".";
                int prefixLen = nodePrefix.length();
                ArrayList<ClusterNodeConfiguration> nodes = new ArrayList<ClusterNodeConfiguration>();
                for (String propertyName : properties.stringPropertyNames()) {
                    int idx;
                    String nodeName;
                    if (!propertyName.startsWith(nodePrefix) || !nodeNames.add(nodeName = (idx = propertyName.indexOf(46, prefixLen)) != -1 ? propertyName.substring(prefixLen, idx) : propertyName.substring(prefixLen))) continue;
                    ClusterNodeConfiguration.Builder builder = new ClusterNodeConfiguration.Builder();
                    builder.setNodeName(nodeName);
                    if (!builder.populateFromProperties(properties, nodePrefix + nodeName + ".", classLoader, this)) continue;
                    nodes.add(new ClusterNodeConfiguration(builder));
                }
                this.setNodeConfigurations(nodes);
                return true;
            }
        }
    }

    public static class ConnectionConfiguration
    extends CommonSubconfiguration {
        private final String host;
        private final int port;
        private final String protocol;

        ConnectionConfiguration(Builder builder) {
            super(builder);
            this.host = builder.host;
            this.port = builder.port;
            this.protocol = builder.protocol;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getProtocol() {
            return this.protocol;
        }

        static final class Builder
        extends CommonSubconfiguration.Builder {
            String host;
            int port;
            String protocol;

            Builder() {
            }

            @Override
            boolean populateFromProperties(Properties properties, String prefix, ClassLoader classLoader, CommonSubconfiguration.Builder defaultsBuilder) {
                throw Assert.unsupported();
            }

            boolean populateFromProperties(Properties properties, String prefix, ClassLoader classLoader, CommonSubconfiguration.Builder defaultsBuilder, String connectionName) {
                String protocol;
                int port;
                super.populateFromProperties(properties, prefix, classLoader, defaultsBuilder);
                String host = JBossEJBProperties.getProperty(properties, prefix + JBossEJBProperties.PROPERTY_KEY_HOST, "", true).trim();
                if (host.isEmpty()) {
                    Logs.MAIN.skippingConnectionCreationDueToMissingHostOrPort(connectionName);
                    return false;
                }
                this.setHost(host);
                String portStr = JBossEJBProperties.getProperty(properties, prefix + JBossEJBProperties.PROPERTY_KEY_PORT, "", true).trim();
                if (portStr.isEmpty()) {
                    Logs.MAIN.skippingConnectionCreationDueToMissingHostOrPort(connectionName);
                    return false;
                }
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException e) {
                    Logs.MAIN.skippingConnectionCreationDueToInvalidPortNumber(portStr, connectionName);
                    return false;
                }
                this.setPort(port);
                this.protocol = protocol = JBossEJBProperties.getProperty(properties, prefix + JBossEJBProperties.PROPERTY_KEY_PROTOCOL, JBossEJBProperties.DEFAULT_PROTOCOL, true).trim();
                return true;
            }

            Builder setHost(String host) {
                this.host = host;
                return this;
            }

            Builder setPort(int port) {
                this.port = port;
                return this;
            }
        }
    }

    static abstract class CommonSubconfiguration {
        private final OptionMap connectionOptions;
        private final String callbackHandlerClassName;
        private final ExceptionSupplier<CallbackHandler, ReflectiveOperationException> callbackHandlerSupplier;
        private final long connectionTimeout;
        private final OptionMap channelOptions;
        private final boolean connectEagerly;
        private final AuthenticationConfiguration authenticationConfiguration;

        CommonSubconfiguration(Builder builder) {
            this.connectionOptions = builder.connectionOptions;
            this.callbackHandlerClassName = builder.callbackHandlerClassName;
            this.callbackHandlerSupplier = builder.callbackHandlerSupplier;
            this.connectionTimeout = builder.connectionTimeout;
            this.channelOptions = builder.channelOptions;
            this.connectEagerly = builder.connectEagerly;
            this.authenticationConfiguration = builder.authenticationConfiguration;
        }

        public OptionMap getConnectionOptions() {
            return this.connectionOptions;
        }

        public long getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public boolean isConnectEagerly() {
            return this.connectEagerly;
        }

        public String getCallbackHandlerClassName() {
            return this.callbackHandlerClassName;
        }

        public AuthenticationConfiguration getAuthenticationConfiguration() {
            return this.authenticationConfiguration;
        }

        public OptionMap getChannelOptions() {
            return this.channelOptions;
        }

        public ExceptionSupplier<CallbackHandler, ReflectiveOperationException> getCallbackHandlerSupplier() {
            return this.callbackHandlerSupplier;
        }

        static abstract class Builder {
            OptionMap connectionOptions;
            String callbackHandlerClassName;
            ExceptionSupplier<CallbackHandler, ReflectiveOperationException> callbackHandlerSupplier;
            long connectionTimeout;
            OptionMap channelOptions;
            boolean connectEagerly;
            AuthenticationConfiguration authenticationConfiguration;

            Builder() {
            }

            Builder setConnectionOptions(OptionMap connectionOptions) {
                this.connectionOptions = connectionOptions;
                return this;
            }

            Builder setCallbackHandlerClassName(String callbackHandlerClassName) {
                this.callbackHandlerClassName = callbackHandlerClassName;
                return this;
            }

            Builder setCallbackHandlerSupplier(ExceptionSupplier<CallbackHandler, ReflectiveOperationException> callbackHandlerSupplier) {
                this.callbackHandlerSupplier = callbackHandlerSupplier;
                return this;
            }

            Builder setConnectionTimeout(long connectionTimeout) {
                this.connectionTimeout = connectionTimeout;
                return this;
            }

            Builder setChannelOptions(OptionMap channelOptions) {
                this.channelOptions = channelOptions;
                return this;
            }

            Builder setConnectEagerly(boolean connectEagerly) {
                this.connectEagerly = connectEagerly;
                return this;
            }

            Builder setAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            boolean populateFromProperties(Properties properties, String prefix, ClassLoader classLoader, Builder defaultsBuilder) {
                String connectOptionsPrefix = prefix + "connect.options" + ".";
                this.setConnectionOptions(JBossEJBProperties.getOptionMapFromProperties(properties, connectOptionsPrefix, classLoader));
                this.setConnectionTimeout(JBossEJBProperties.getLongValueFromProperties(properties, prefix + "connect.timeout", defaultsBuilder == null ? 5000L : defaultsBuilder.connectionTimeout));
                this.setConnectEagerly(Boolean.parseBoolean(JBossEJBProperties.getProperty(properties, prefix + "connect.eager", Boolean.toString(defaultsBuilder == null || defaultsBuilder.connectEagerly), true).trim()));
                String callbackHandlerClassName = JBossEJBProperties.getProperty(properties, prefix + JBossEJBProperties.PROPERTY_KEY_CALLBACK_HANDLER_CLASS, null, true);
                this.setCallbackHandlerClassName(callbackHandlerClassName);
                AuthenticationConfiguration.Builder authBuilder = new AuthenticationConfiguration.Builder();
                if (authBuilder.populateFromProperties(properties, prefix, classLoader)) {
                    this.setAuthenticationConfiguration(new AuthenticationConfiguration(authBuilder));
                } else if (defaultsBuilder != null) {
                    this.setAuthenticationConfiguration(defaultsBuilder.authenticationConfiguration);
                }
                this.setChannelOptions(JBossEJBProperties.getOptionMapFromProperties(properties, prefix + "channel.options" + ".", classLoader));
                ExceptionSupplier callbackHandlerSupplier = () -> Class.forName(callbackHandlerClassName, true, classLoader).asSubclass(CallbackHandler.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                return true;
            }
        }
    }

    static final class Builder
    extends CommonSubconfiguration.Builder {
        String endpointName;
        OptionMap endpointCreationOptions;
        OptionMap remoteConnectionProviderCreationOptions;
        List<ConnectionConfiguration> connectionList;
        Map<String, ClusterConfiguration> clusterConfigurations;
        long invocationTimeout;
        long reconnectTimeout;
        String deploymentNodeSelectorClassName;
        ExceptionSupplier<DeploymentNodeSelector, ReflectiveOperationException> deploymentNodeSelectorSupplier;

        Builder() {
        }

        Builder setEndpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        Builder setEndpointCreationOptions(OptionMap endpointCreationOptions) {
            this.endpointCreationOptions = endpointCreationOptions;
            return this;
        }

        Builder setRemoteConnectionProviderCreationOptions(OptionMap remoteConnectionProviderCreationOptions) {
            this.remoteConnectionProviderCreationOptions = remoteConnectionProviderCreationOptions;
            return this;
        }

        Builder setConnectionList(List<ConnectionConfiguration> connectionList) {
            this.connectionList = connectionList;
            return this;
        }

        Builder setClusterConfigurations(Map<String, ClusterConfiguration> clusterConfigurations) {
            this.clusterConfigurations = clusterConfigurations;
            return this;
        }

        Builder setInvocationTimeout(long invocationTimeout) {
            this.invocationTimeout = invocationTimeout;
            return this;
        }

        Builder setReconnectTimeout(long reconnectTimeout) {
            this.reconnectTimeout = reconnectTimeout;
            return this;
        }

        Builder setDeploymentNodeSelectorClassName(String deploymentNodeSelectorClassName) {
            this.deploymentNodeSelectorClassName = deploymentNodeSelectorClassName;
            return this;
        }

        Builder setDeploymentNodeSelectorSupplier(ExceptionSupplier<DeploymentNodeSelector, ReflectiveOperationException> deploymentNodeSelectorSupplier) {
            this.deploymentNodeSelectorSupplier = deploymentNodeSelectorSupplier;
            return this;
        }
    }
}

