/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.oauth2;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.mechanism.oauth2.OAuth2Server;
import org.wildfly.security.sasl.oauth2.OAuth2SaslServer;

public final class OAuth2SaslServerFactory
implements SaslServerFactory {
    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        if (this.getMechanismNames(props, false).length == 0) {
            return null;
        }
        switch (mechanism) {
            case "OAUTHBEARER": {
                return new OAuth2SaslServer(mechanism, protocol, serverName, cbh, new OAuth2Server(mechanism, cbh, props));
            }
        }
        return null;
    }

    private String[] getMechanismNames(Map<String, ?> props, boolean query) {
        if (props == null) {
            return new String[]{"OAUTHBEARER"};
        }
        if ("true".equals(props.get("wildfly.sasl.mechanism-query-all")) && query) {
            return new String[]{"OAUTHBEARER"};
        }
        if ("true".equals(props.get("javax.security.sasl.policy.noplaintext")) || "true".equals(props.get("javax.security.sasl.policy.noactive")) || "true".equals(props.get("javax.security.sasl.policy.nodictionary"))) {
            return new String[0];
        }
        return new String[]{"OAUTHBEARER"};
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return this.getMechanismNames(props, true);
    }
}

