package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.Util;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla3 extends ReceiverAdapter {
    protected JChannel ch;


    protected void start(String name) throws Exception {
        ch=new JChannel("/home/bela/test.xml").name(name).setReceiver(this);
        ch.connect("demo");
    }

    protected void reconnect() throws Exception {
        ch.disconnect();
        ch.connect("demo");
    }

    public void viewAccepted(View view) {
        System.out.printf("-- view: %s\n", view);
        if(view.size() >= 2 && view.getCoord().equals(ch.getAddress())) {
            new Thread(() -> {
                try {
                    Util.sleep(1000);
                    reconnect();
                }
                catch(Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
    }

    public static void main(String[] args) throws Exception {
        bla3 b=new bla3();
        b.start(args[0]);
    }



}
