package org.jgroups.tests;


import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.TP;
import org.jgroups.util.LazyThreadFactory;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla9 {
    public static void main(String[] args) throws Exception {
        JChannel jChannel = new JChannel("/home/bela/fast.xml");

        TP transport=jChannel.getProtocolStack().getTransport();
        transport.setInternalThreadPoolThreadFactory(new MyThreadFactory("jgroups", false, true));

        jChannel.setReceiver(new ReceiverAdapter() {
            public void viewAccepted(View view) {
                System.out.println("view = " + view);
            }
        });
        jChannel.connect("demo");

    }



    protected static class MyThreadFactory extends LazyThreadFactory {

        public MyThreadFactory(String baseName, boolean createDaemons, boolean use_numbering) {
            super(baseName, createDaemons, use_numbering);
        }

        public Thread newThread(Runnable r, String name) {
            return super.newThread(r, "bela-" + name);
        }

        public Thread newThread(Runnable r) {
            Thread t=super.newThread(r);
            t.setName("bela-" + t.getName());
            return t;
        }

        protected Thread newThread(Runnable r, String name, String addr, String cluster_name) {
            return super.newThread(r, "bela-" + name, addr, cluster_name);
        }
    }

}
