/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.jboss.ejb.client.SessionID;

public final class UUIDSessionID
extends SessionID {
    private static final long serialVersionUID = -7306257085240447972L;
    private final UUID uuid;

    UUIDSessionID(byte[] encodedForm) {
        super(encodedForm);
        if (encodedForm[0] != 9) {
            throw UUIDSessionID.wrongFormat();
        }
        ByteBuffer bb = ByteBuffer.wrap(encodedForm);
        bb.get();
        this.uuid = new UUID(bb.getLong(), bb.getLong());
    }

    public UUIDSessionID(UUID uuid) {
        super(UUIDSessionID.encode(uuid));
        this.uuid = uuid;
    }

    private static byte[] encode(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[17]);
        bb.put((byte)9);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    private static IllegalArgumentException wrongFormat() {
        return new IllegalArgumentException("Wrong session ID format");
    }

    @Override
    public String toString() {
        return String.format("%s [%s]", this.getClass().getSimpleName(), this.uuid);
    }
}

