/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.util.Util;

public class ChallengeResponseHeader
extends Header {
    protected static final byte CHALLENGE = 1;
    protected static final byte RESPONSE = 2;
    protected byte type;
    protected byte[] payload;
    protected long hash;

    public ChallengeResponseHeader() {
    }

    public ChallengeResponseHeader(byte[] payload) {
        this.type = 1;
        this.payload = payload;
    }

    public ChallengeResponseHeader(long hash) {
        this.type = (byte)2;
        this.hash = hash;
    }

    @Override
    public short getMagicId() {
        return 90;
    }

    @Override
    public Supplier<? extends Header> create() {
        return ChallengeResponseHeader::new;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeByte(this.type);
        switch (this.type) {
            case 1: {
                Util.writeByteBuffer(this.payload, out);
                break;
            }
            case 2: {
                out.writeLong(this.hash);
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.type = in.readByte();
        switch (this.type) {
            case 1: {
                this.payload = Util.readByteBuffer(in);
                break;
            }
            case 2: {
                this.hash = in.readLong();
            }
        }
    }

    @Override
    public int serializedSize() {
        int retval = 1;
        switch (this.type) {
            case 1: {
                retval += Util.size(this.payload);
                break;
            }
            case 2: {
                retval += 8;
            }
        }
        return retval;
    }

    @Override
    public String toString() {
        return this.type == 1 ? "CHALLENGE" : "RESPONSE, payload=" + (this.payload != null ? this.payload.length : 0) + " bytes";
    }
}

