/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.util;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.FastHashtable;

public final class NamingUtils {
    private NamingUtils() {
    }

    public static Name parentOf(Name name) {
        return name.isEmpty() ? name : name.getPrefix(name.size() - 1);
    }

    public static CompositeName toCompositeName(Name name) throws InvalidNameException {
        if (name instanceof CompositeName) {
            return (CompositeName)name;
        }
        CompositeName compositeName = new CompositeName();
        compositeName.add(name.toString());
        return compositeName;
    }

    public static CompositeName toDecomposedCompositeName(Name name) throws InvalidNameException {
        if (name instanceof CompositeName) {
            return (CompositeName)name;
        }
        CompositeName compositeName = new CompositeName();
        Enumeration<String> enumeration = name.getAll();
        if (enumeration.hasMoreElements()) {
            int idx = 0;
            do {
                String item;
                if ((item = enumeration.nextElement()) == null) {
                    throw Messages.log.invalidNullSegment(idx);
                }
                compositeName.add(item);
                ++idx;
            } while (enumeration.hasMoreElements());
        }
        return compositeName;
    }

    public static Context emptyContext(Hashtable<String, Object> environment) {
        return new AbstractContext((FastHashtable)FastHashtable.of(environment)){

            @Override
            protected Object lookupNative(Name name) throws NamingException {
                throw Messages.log.nameNotFound(name, name);
            }

            @Override
            protected void bindNative(Name name, Object obj) throws NamingException {
                throw Messages.log.readOnlyContext();
            }

            @Override
            protected void rebindNative(Name name, Object obj) throws NamingException {
                throw Messages.log.nameNotFound(name, name);
            }

            @Override
            protected void unbindNative(Name name) throws NamingException {
                throw Messages.log.nameNotFound(name, name);
            }

            @Override
            protected void renameNative(Name oldName, Name newName) throws NamingException {
                throw Messages.log.nameNotFound(oldName, oldName);
            }

            @Override
            protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
                if (name.isEmpty()) {
                    return CloseableNamingEnumeration.empty();
                }
                throw Messages.log.nameNotFound(name, name);
            }

            @Override
            protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
                if (name.isEmpty()) {
                    return CloseableNamingEnumeration.empty();
                }
                throw Messages.log.nameNotFound(name, name);
            }

            @Override
            protected void destroySubcontextNative(Name name) throws NamingException {
                throw Messages.log.nameNotFound(name, name);
            }

            @Override
            protected Context createSubcontextNative(Name name) throws NamingException {
                if (name.size() == 1) {
                    throw Messages.log.readOnlyContext();
                }
                throw Messages.log.nameNotFound(name, name);
            }

            @Override
            protected Object lookupLinkNative(Name name) throws NamingException {
                throw Messages.log.nameNotFound(name, name);
            }

            @Override
            public void close() throws NamingException {
            }

            @Override
            public String getNameInNamespace() throws NamingException {
                return "";
            }
        };
    }

    public static void safeClose(Context context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Throwable t) {
                Messages.log.contextCloseFailed(context, t);
            }
        }
    }

    public static NamingException namingException(String message, Throwable cause) {
        NamingException namingException = new NamingException(message);
        if (cause != null) {
            namingException.setRootCause(cause);
        }
        return namingException;
    }
}

