package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.Frag3Header;
import org.jgroups.protocols.pbcast.NakAckHeader2;
import org.jgroups.util.Util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla {
    public static void main(String[] args) {
        List<String> list=Arrays.asList("one", "two", "three", "four", "five");

        String tmp=Util.print(list);
        System.out.println("tmp = " + tmp);

        String res=list.stream().collect(Collectors.joining(", ", "{", "}"));
          // String.join(" : ", list);
        System.out.println("res = " + res);

        Address dest=null, src=Util.createRandomAddress("B");

        String str=String.format("dest: %s src: %s\n", dest, src);
        System.out.println("str = " + str);

        Message msg=new Message(null, "hello world").setSrc(src).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL);
        System.out.println("msg = " + msg);

        msg.setDest(src).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK);
        System.out.println("msg = " + msg);

        msg.putHeader((short)1, new NakAckHeader2()).putHeader((short)2, new Frag3Header());

        msg.setBuffer(null, 0, 0);
        System.out.println("msg = " + msg);
    }
}



