/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.net.URI;
import org.wildfly.common.Assert;

public final class ConnectionBuilder {
    private final URI destination;
    private int readTimeout = 120000;
    private int writeTimeout = 120000;
    private boolean tcpKeepAlive = true;
    private int ipTrafficClass = -1;
    private int heartbeatInterval = 60000;

    ConnectionBuilder(URI destination) {
        this.destination = destination;
    }

    public ConnectionBuilder setReadTimeout(int readTimeout) {
        Assert.checkMinimumParameter("readTimeout", 0L, (long)readTimeout);
        this.readTimeout = readTimeout;
        return this;
    }

    public ConnectionBuilder setWriteTimeout(int writeTimeout) {
        Assert.checkMinimumParameter("writeTimeout", 0L, (long)writeTimeout);
        this.writeTimeout = writeTimeout;
        return this;
    }

    public ConnectionBuilder setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
        return this;
    }

    public ConnectionBuilder setIpTrafficClass(int ipTrafficClass) {
        this.ipTrafficClass = ipTrafficClass;
        return this;
    }

    public ConnectionBuilder setHeartbeatInterval(int heartbeatInterval) {
        Assert.checkMinimumParameter("heartbeatInterval", 0, heartbeatInterval);
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    URI getDestination() {
        return this.destination;
    }

    int getReadTimeout() {
        return this.readTimeout;
    }

    int getWriteTimeout() {
        return this.writeTimeout;
    }

    boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    int getIPTrafficClass() {
        return this.ipTrafficClass;
    }

    int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }
}

