/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.interfaces.RawPassword;
import org.wildfly.security.password.interfaces.SimpleDigestPassword;

class RawSimpleDigestPassword
extends RawPassword
implements SimpleDigestPassword {
    private static final long serialVersionUID = -4517729891352607948L;
    private final byte[] digest;

    RawSimpleDigestPassword(String algorithm, byte[] digest) {
        super(algorithm);
        this.digest = digest;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public RawSimpleDigestPassword clone() {
        return this;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered(Arrays.hashCode(this.digest), this.getAlgorithm().hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RawSimpleDigestPassword)) {
            return false;
        }
        RawSimpleDigestPassword other = (RawSimpleDigestPassword)obj;
        return this.getAlgorithm().equals(other.getAlgorithm()) && Arrays.equals(this.digest, other.digest);
    }
}

