/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import java.util.function.Function;
import org.wildfly.common.Assert;
import org.wildfly.security.evidence.Evidence;

@FunctionalInterface
public interface EvidenceDecoder
extends Function<Evidence, Principal> {
    public Principal getPrincipal(Evidence var1);

    @Override
    default public Principal apply(Evidence evidence) {
        return this.getPrincipal(evidence);
    }

    public static EvidenceDecoder aggregate(EvidenceDecoder ... decoders) {
        Assert.checkNotNullParam("decoders", decoders);
        return evidence -> {
            for (EvidenceDecoder decoder : decoders) {
                Principal result = decoder.getPrincipal(evidence);
                if (result == null) continue;
                return result;
            }
            return null;
        };
    }
}

