/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.dns;

import java.util.LinkedHashSet;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.dns.AddressedDNSResolver;
import org.jgroups.protocols.dns.DNSResolver;
import org.jgroups.protocols.dns.DefaultDNSResolver;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.NameCache;
import org.jgroups.util.Responses;

public class DNS_PING
extends Discovery {
    private static final String DEFAULT_DNS_FACTORY = "com.sun.jndi.dns.DnsContextFactory";
    private static final String DEFAULT_DNS_RECORD_TYPE = "A";
    @Property(description="DNS Context Factory.  Used when DNS_PING is configured to use SRV record types and when using A types with a specific dns_address.")
    protected String dns_context_factory = "com.sun.jndi.dns.DnsContextFactory";
    @Property(description="DNS Address. This property will be assembled with the 'dns://' prefix.  If this is specified, A records will be resolved through DnsContext.")
    protected String dns_address = "";
    @Property(description="DNS Record type")
    protected String dns_record_type = "A";
    @Property(description="DNS query for fetching members")
    protected String dns_query;
    @Property(description="For SRV records returned by the DNS query, the non-0 ports returned by DNS areused. If this attribute is true, then the transport ports will also be used. Ignored for A records.")
    protected boolean probe_transport_ports;
    protected volatile DNSResolver dns_resolver;
    private int transportPort;
    private int portRange;

    @Override
    public void init() throws Exception {
        super.init();
        this.validateProperties();
        this.transportPort = this.getTransport().getBindPort();
        this.portRange = this.getTransport().getPortRange();
        if (this.dns_resolver == null) {
            this.dns_resolver = this.dns_address == null || this.dns_address.isEmpty() ? new DefaultDNSResolver(this.dns_context_factory, this.dns_address) : new AddressedDNSResolver(this.dns_context_factory, this.dns_address);
        }
    }

    protected void validateProperties() {
        if (this.dns_query == null || this.dns_query.trim().isEmpty()) {
            throw new IllegalArgumentException("dns_query can not be null or empty");
        }
    }

    @Override
    public void destroy() {
        if (this.dns_resolver != null) {
            this.dns_resolver.close();
        }
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @ManagedOperation(description="Executes the DNS query and returns the result in string format")
    public String fetchFromDns() {
        long start = System.currentTimeMillis();
        List<Address> dns_discovery_members = this.dns_resolver.resolveIps(this.dns_query, DNSResolver.DNSRecordType.valueOf(this.dns_record_type));
        String ret = dns_discovery_members != null ? dns_discovery_members.toString() : null;
        long time = System.currentTimeMillis() - start;
        return String.format("%s\n(took %d ms)\n", ret, time);
    }

    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        PingData data = null;
        PhysicalAddress physical_addr = null;
        LinkedHashSet<IpAddress> cluster_members = new LinkedHashSet<IpAddress>();
        DNSResolver.DNSRecordType record_type = DNSResolver.DNSRecordType.valueOf(this.dns_record_type);
        if (!this.use_ip_addrs || !initial_discovery) {
            physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
            data = new PingData(this.local_addr, false, NameCache.get(this.local_addr), physical_addr);
            if (members != null && members.size() <= this.max_members_in_discovery_request) {
                data.mbrs(members);
            }
        }
        long start = System.currentTimeMillis();
        List<Address> dns_discovery_members = this.dns_resolver.resolveIps(this.dns_query, record_type);
        long time = System.currentTimeMillis() - start;
        if (this.log.isDebugEnabled()) {
            if (dns_discovery_members != null && !dns_discovery_members.isEmpty()) {
                this.log.debug("%s: entries collected from DNS (in %d ms): %s", this.local_addr, time, dns_discovery_members);
            } else {
                this.log.debug("%s: no entries collected from DNS (in %d ms)", this.local_addr, time);
            }
        }
        boolean ports_found = false;
        if (dns_discovery_members != null) {
            for (Address address : dns_discovery_members) {
                if (address.equals(physical_addr) || !(address instanceof IpAddress)) continue;
                IpAddress ipAddress = (IpAddress)address;
                if (record_type == DNSResolver.DNSRecordType.SRV && ipAddress.getPort() > 0) {
                    ports_found = true;
                    cluster_members.add(ipAddress);
                    if (!this.probe_transport_ports) continue;
                }
                for (int i = 0; i <= this.portRange; ++i) {
                    cluster_members.add(new IpAddress(ipAddress.getIpAddress(), this.transportPort + i));
                }
            }
        }
        if (dns_discovery_members != null && !dns_discovery_members.isEmpty() && this.log.isDebugEnabled()) {
            if (ports_found) {
                this.log.debug("%s: sending discovery requests to %s", this.local_addr, cluster_members);
            } else {
                this.log.debug("%s: sending discovery requests to hosts %s on ports [%d .. %d]", this.local_addr, dns_discovery_members, this.transportPort, this.transportPort + this.portRange);
            }
        }
        PingHeader hdr = new PingHeader(1).clusterName(this.cluster_name).initialDiscovery(initial_discovery);
        for (Address address : cluster_members) {
            Message msg = new Message(address).setFlag(Message.Flag.INTERNAL, Message.Flag.DONT_BUNDLE, Message.Flag.OOB).putHeader(this.id, hdr);
            if (data != null) {
                msg.setBuffer(DNS_PING.marshal(data));
            }
            if (this.async_discovery_use_separate_thread_per_request) {
                this.timer.execute(() -> this.sendDiscoveryRequest(msg), this.sends_can_block);
                continue;
            }
            this.sendDiscoveryRequest(msg);
        }
    }

    protected void sendDiscoveryRequest(Message req) {
        try {
            this.log.trace("%s: sending discovery request to %s", this.local_addr, req.getDest());
            this.down_prot.down(req);
        }
        catch (Throwable t) {
            this.log.error("sending discovery request to %s failed: %s", req.dest(), t);
        }
    }
}

