package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

import java.nio.ByteBuffer;


/**
 * @author Bela Ban
 * @since x.y
 */
public class bla6 extends ReceiverAdapter {
    protected JChannel     channel;
    protected final byte[] s="hello world".getBytes();

    protected void start() throws Exception {
        channel=new JChannel().connect("demo").setReceiver(this);

        byte[] metadata=createMetadata();

        ByteBuffer payload=ByteBuffer.allocate(s.length);
        payload.put(s, 0, s.length).rewind();

        byte[] temp_array=new byte[metadata.length + payload.remaining()];
        System.arraycopy(metadata, 0, temp_array, 0, metadata.length);
        System.arraycopy(payload.array(), payload.arrayOffset(), temp_array, metadata.length, payload.remaining());

        Message msg=new Message(null, temp_array);
        System.out.printf("sending %s : %s\n", new String(metadata), new String(payload.array()));
        channel.send(msg);
    }

    public void receive(Message msg) {
        byte[] array=msg.getRawBuffer();
        int offset=msg.getOffset();
        int len=msg.getLength();

        byte[] metadata=new byte[4];
        System.arraycopy(array, offset, metadata, 0, metadata.length);
        ByteBuffer payload=ByteBuffer.allocate(s.length);
        payload.put(array, metadata.length, len-metadata.length);
        System.out.printf("received %s : %s\n", new String(metadata), new String(payload.array()));
        new Thread(() -> Util.close(channel)).start();
    }

    public void receive(MessageBatch batch) {
        for(Message msg: batch) {
            receive(msg);
        }
    }

    private static byte[] createMetadata() {
        return "1234".getBytes();
    }

    public static void main(String[] args) throws Exception {
        new bla6().start();
    }




}
