/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.InputStream;
import java.net.Socket;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXReason;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.Assert;
import org.wildfly.security.ssl.ElytronMessages;
import org.wildfly.security.x500.X500;

public class X509RevocationTrustManager
extends X509ExtendedTrustManager {
    private static final int DEFAULT_MAX_CERT_PATH_LENGTH = 5;
    private final X509Certificate[] acceptedIssuers;
    private final X509TrustManager trustManager;

    private X509RevocationTrustManager(Builder builder) {
        try {
            PKIXBuilderParameters params = new PKIXBuilderParameters(builder.trustStore, (CertSelector)new X509CertSelector());
            if (builder.crlStream != null) {
                CollectionCertStoreParameters csp = new CollectionCertStoreParameters(this.getCRLs(builder.crlStream));
                CertStore store = CertStore.getInstance("Collection", csp);
                params.addCertStore(store);
            }
            CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX");
            PKIXRevocationChecker rc = (PKIXRevocationChecker)cpb.getRevocationChecker();
            if (builder.ocspResponderCert != null) {
                rc.setOcspResponderCert(builder.ocspResponderCert);
            }
            EnumSet<PKIXRevocationChecker.Option> options = EnumSet.noneOf(PKIXRevocationChecker.Option.class);
            if (builder.onlyEndEntity) {
                options.add(PKIXRevocationChecker.Option.ONLY_END_ENTITY);
            }
            if (builder.preferCrls) {
                options.add(PKIXRevocationChecker.Option.PREFER_CRLS);
            }
            if (builder.softFail) {
                options.add(PKIXRevocationChecker.Option.SOFT_FAIL);
            }
            if (builder.noFallback) {
                options.add(PKIXRevocationChecker.Option.NO_FALLBACK);
            }
            rc.setOptions(options);
            rc.setOcspResponder(builder.responderUri);
            params.setRevocationEnabled(true);
            params.addCertPathChecker(rc);
            MaxPathLengthChecker maxPathLengthChecker = new MaxPathLengthChecker(builder.maxCertPath);
            params.addCertPathChecker(maxPathLengthChecker);
            params.setMaxPathLength(builder.maxCertPath);
            builder.trustManagerFactory.init(new CertPathTrustManagerParameters(params));
            X509TrustManager[] trustManagers = (X509TrustManager[])Stream.of(builder.trustManagerFactory.getTrustManagers()).map(trustManager -> trustManager instanceof X509TrustManager ? (X509TrustManager)trustManager : null).filter(Objects::nonNull).toArray(X509TrustManager[]::new);
            if (trustManagers.length == 0) {
                throw ElytronMessages.log.noDefaultTrustManager();
            }
            this.trustManager = trustManagers[0];
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.sslErrorCreatingRevocationTrustManager(builder.trustManagerFactory.getAlgorithm(), e);
        }
        this.acceptedIssuers = builder.acceptedIssuers != null ? builder.acceptedIssuers : X500.NO_CERTIFICATES;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends CRL> getCRLs(InputStream crlStream) throws GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try {
            Collection<? extends CRL> collection = cf.generateCRLs(crlStream);
            return collection;
        }
        finally {
            try {
                crlStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private class MaxPathLengthChecker
    extends PKIXCertPathChecker {
        private int maxPathLength;
        private int i;

        MaxPathLengthChecker(int maxPathLength) {
            this.maxPathLength = maxPathLength;
        }

        @Override
        public void init(boolean forward) {
            this.i = 0;
        }

        @Override
        public boolean isForwardCheckingSupported() {
            return false;
        }

        @Override
        public Set<String> getSupportedExtensions() {
            return null;
        }

        public void check(Certificate cert, Collection unresolvedCritExts) throws CertPathValidatorException {
            X509Certificate currCert = (X509Certificate)cert;
            ++this.i;
            this.checkCertPathLength(currCert);
        }

        private void checkCertPathLength(X509Certificate currCert) throws CertPathValidatorException {
            X500Principal subject = currCert.getSubjectX500Principal();
            X500Principal issuer = currCert.getIssuerX500Principal();
            int pathLenConstraint = -1;
            if (currCert.getVersion() < 3) {
                if (this.i == 1 && subject.equals(issuer)) {
                    pathLenConstraint = Integer.MAX_VALUE;
                }
            } else {
                pathLenConstraint = currCert.getBasicConstraints();
            }
            if (pathLenConstraint == -1) {
                pathLenConstraint = this.maxPathLength;
            }
            if (!subject.equals(issuer) && pathLenConstraint < this.i) {
                throw new CertPathValidatorException("check failed: pathLenConstraint violated - this cert must be the last cert in the certification path", null, null, -1, PKIXReason.PATH_TOO_LONG);
            }
            if (pathLenConstraint < this.maxPathLength) {
                this.maxPathLength = pathLenConstraint;
            }
        }
    }

    public static class Builder {
        private X509Certificate[] acceptedIssuers = null;
        private KeyStore trustStore = null;
        private TrustManagerFactory trustManagerFactory = null;
        private URI responderUri = null;
        private InputStream crlStream = null;
        private X509Certificate ocspResponderCert = null;
        private int maxCertPath = 5;
        private boolean preferCrls = false;
        private boolean onlyEndEntity = false;
        private boolean softFail = false;
        private boolean noFallback = false;

        private Builder() {
        }

        public Builder setAcceptedIssuers(X509Certificate[] acceptedIssuers) {
            this.acceptedIssuers = acceptedIssuers;
            return this;
        }

        public Builder setTrustStore(KeyStore trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public Builder setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
            this.trustManagerFactory = trustManagerFactory;
            return this;
        }

        public Builder setResponderURI(URI responderURI) {
            this.responderUri = responderURI;
            return this;
        }

        public Builder setCrlStream(InputStream crlStream) {
            this.crlStream = crlStream;
            return this;
        }

        public Builder setMaxCertPath(int maxCertPath) {
            this.maxCertPath = maxCertPath;
            return this;
        }

        public Builder setPreferCrls(boolean preferCrls) {
            this.preferCrls = preferCrls;
            return this;
        }

        public Builder setOnlyEndEntity(boolean onlyEndEntity) {
            this.onlyEndEntity = onlyEndEntity;
            return this;
        }

        public Builder setSoftFail(boolean softFail) {
            this.softFail = softFail;
            return this;
        }

        public Builder setNoFallback(boolean noFallback) {
            this.noFallback = noFallback;
            return this;
        }

        public Builder setOcspResponderCert(X509Certificate ocspResponderCert) {
            this.ocspResponderCert = ocspResponderCert;
            return this;
        }

        public X509RevocationTrustManager build() {
            Assert.checkNotNullParam("trustStore", this.trustStore);
            Assert.checkNotNullParam("trustManagerFactory", this.trustManagerFactory);
            return new X509RevocationTrustManager(this);
        }
    }
}

