package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla2 implements Receiver {
    protected JChannel main_ch;
    protected static final int NUM=1;

    protected void start() throws Exception {
        main_ch=new JChannel("/Users/bela/sequencer.xml").name("A");
        main_ch.connect("cluster");
        main_ch.setReceiver(this);


        while(true) {
            int c=Util.keyPress(">");
            for(int i=0; i < NUM; i++) {
                Message msg=new Message(null, i);
                main_ch.send(msg);
            }
        }
    }

    public void receive(Message msg) {
        System.out.printf("-- received %s from %s\n", msg.getObject(), msg.src());
    }

    public void receive(MessageBatch batch) {
        System.out.printf("-- received %d msgs from %s:\n%s\n", batch.size(), batch.sender(),
                          batch.stream().map(Message::getObject).filter(Objects::nonNull).map(Object::toString)
                            .collect(Collectors.joining(" ")));
    }

    public static void main(String[] args) throws Exception {

        new bla2().start();

    }



}
