/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import javax.json.JsonObject;
import org.apache.activemq.artemis.api.core.JsonUtil;

public final class MessageCounterInfo {
    private final String name;
    private final String subscription;
    private final boolean durable;
    private final long count;
    private final long countDelta;
    private final int depth;
    private final int depthDelta;
    private final String lastAddTimestamp;
    private final String lastAckTimestamp;
    private final String updateTimestamp;

    public static MessageCounterInfo fromJSON(String jsonString) throws Exception {
        JsonObject data = JsonUtil.readJsonObject(jsonString);
        String name = data.getString("destinationName");
        String subscription = data.getString("destinationSubscription", null);
        boolean durable = data.getBoolean("destinationDurable");
        long count = data.getJsonNumber("count").longValue();
        long countDelta = data.getJsonNumber("countDelta").longValue();
        int depth = data.getInt("messageCount");
        int depthDelta = data.getInt("messageCountDelta");
        String lastAddTimestamp = data.getString("lastAddTimestamp");
        String lastAckTimestamp = data.getString("lastAckTimestamp");
        String updateTimestamp = data.getString("updateTimestamp");
        return new MessageCounterInfo(name, subscription, durable, count, countDelta, depth, depthDelta, lastAddTimestamp, lastAckTimestamp, updateTimestamp);
    }

    public MessageCounterInfo(String name, String subscription, boolean durable, long count, long countDelta, int depth, int depthDelta, String lastAddTimestamp, String lastAckTimestamp, String udpateTimestamp) {
        this.name = name;
        this.subscription = subscription;
        this.durable = durable;
        this.count = count;
        this.countDelta = countDelta;
        this.depth = depth;
        this.depthDelta = depthDelta;
        this.lastAddTimestamp = lastAddTimestamp;
        this.lastAckTimestamp = lastAckTimestamp;
        this.updateTimestamp = udpateTimestamp;
    }

    public String getName() {
        return this.name;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public long getCount() {
        return this.count;
    }

    public long getCountDelta() {
        return this.countDelta;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getDepthDelta() {
        return this.depthDelta;
    }

    public String getLastAddTimestamp() {
        return this.lastAddTimestamp;
    }

    public String getLastAckTimestamp() {
        return this.lastAckTimestamp;
    }

    public String getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    @Deprecated
    public String getUdpateTimestamp() {
        return this.updateTimestamp;
    }
}

