/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth.sasl;

import java.io.File;
import java.util.TimerTask;
import org.jgroups.auth.sasl.FileObserver;

public class FileWatchTask
extends TimerTask {
    private final File file;
    private long modified;
    private final FileObserver observer;

    public FileWatchTask(File file, FileObserver observer) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File '" + file + "' does not exist");
        }
        this.file = file;
        this.modified = file.lastModified();
        this.observer = observer;
    }

    @Override
    public void run() {
        long modifiedLocal = this.file.lastModified();
        if (this.modified != modifiedLocal) {
            this.modified = modifiedLocal;
            this.observer.fileChanged(this.file);
        }
    }
}

