/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.util.Map;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.jose4j.jwt.JwtClaims;
import org.wildfly.security.http.oidc.AddressClaimSet;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.JsonWebToken;
import org.wildfly.security.http.oidc.OidcClientConfiguration;

public class IDToken
extends JsonWebToken {
    public static final String AT_HASH = "at_hash";
    public static final String C_HASH = "c_hash";
    public static final String NAME = "name";
    public static final String GIVEN_NAME = "given_name";
    public static final String FAMILY_NAME = "family_name";
    public static final String MIDDLE_NAME = "middle_name";
    public static final String NICKNAME = "nickname";
    public static final String PREFERRED_USERNAME = "preferred_username";
    public static final String PROFILE = "profile";
    public static final String PICTURE = "picture";
    public static final String WEBSITE = "website";
    public static final String EMAIL = "email";
    public static final String EMAIL_VERIFIED = "email_verified";
    public static final String GENDER = "gender";
    public static final String BIRTHDATE = "birthdate";
    public static final String ZONEINFO = "zoneinfo";
    public static final String LOCALE = "locale";
    public static final String PHONE_NUMBER = "phone_number";
    public static final String PHONE_NUMBER_VERIFIED = "phone_number_verified";
    public static final String ADDRESS = "address";
    public static final String UPDATED_AT = "updated_at";
    public static final String CLAIMS_LOCALES = "claims_locales";
    public static final String ACR = "acr";
    public static final String S_HASH = "s_hash";
    public static final String SUB = "sub";

    public IDToken(JwtClaims jwtClaims) {
        super(jwtClaims);
    }

    public String getName() {
        return this.getClaimValueAsString(NAME);
    }

    public String getGivenName() {
        return this.getClaimValueAsString(GIVEN_NAME);
    }

    public String getFamilyName() {
        return this.getClaimValueAsString(FAMILY_NAME);
    }

    public String getMiddleName() {
        return this.getClaimValueAsString(MIDDLE_NAME);
    }

    public String getNickName() {
        return this.getClaimValueAsString(NICKNAME);
    }

    public String getPreferredUsername() {
        return this.getClaimValueAsString(PREFERRED_USERNAME);
    }

    public String getProfile() {
        return this.getClaimValueAsString(PROFILE);
    }

    public String getPicture() {
        return this.getClaimValueAsString(PICTURE);
    }

    public String getWebsite() {
        return this.getClaimValueAsString(WEBSITE);
    }

    public String getEmail() {
        return this.getClaimValueAsString(EMAIL);
    }

    public Boolean getEmailVerified() {
        return this.getClaimValue(EMAIL_VERIFIED, Boolean.class);
    }

    public String getGender() {
        return this.getClaimValueAsString(GENDER);
    }

    public String getBirthdate() {
        return this.getClaimValueAsString(BIRTHDATE);
    }

    public String getZoneinfo() {
        return this.getClaimValueAsString(ZONEINFO);
    }

    public String getLocale() {
        return this.getClaimValueAsString(LOCALE);
    }

    public String getPhoneNumber() {
        return this.getClaimValueAsString(PHONE_NUMBER);
    }

    public Boolean getPhoneNumberVerified() {
        return this.getClaimValue(PHONE_NUMBER_VERIFIED, Boolean.class);
    }

    public AddressClaimSet getAddress() {
        Object addressValue = this.getClaimValue(ADDRESS);
        JsonValue addressValueAsJson = IDToken.wrapValue(addressValue);
        if (!(addressValueAsJson instanceof JsonObject)) {
            throw ElytronMessages.log.invalidTokenClaimValue();
        }
        return new AddressClaimSet((Map)((Object)addressValueAsJson));
    }

    public Long getUpdatedAt() {
        return this.getClaimValueAsLong(UPDATED_AT);
    }

    public String getClaimsLocales() {
        return this.getClaimValueAsString(CLAIMS_LOCALES);
    }

    public String getAccessTokenHash() {
        return this.getClaimValueAsString(AT_HASH);
    }

    public String getCodeHash() {
        return this.getClaimValueAsString(C_HASH);
    }

    public String getStateHash() {
        return this.getClaimValueAsString(S_HASH);
    }

    public String getAcr() {
        return this.getClaimValueAsString(ACR);
    }

    public String getPrincipalName(OidcClientConfiguration deployment) {
        String attr = SUB;
        if (deployment.getPrincipalAttribute() != null) {
            attr = deployment.getPrincipalAttribute();
        }
        switch (attr) {
            case "sub": {
                return this.getSubject();
            }
            case "email": {
                return this.getEmail();
            }
            case "preferred_username": {
                return this.getPreferredUsername();
            }
            case "name": {
                return this.getName();
            }
            case "given_name": {
                return this.getGivenName();
            }
            case "family_name": {
                return this.getFamilyName();
            }
            case "nickname": {
                return this.getNickName();
            }
        }
        return this.getSubject();
    }
}

