/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.jgroups.util.Util;

public class CustomRejectionPolicy
implements RejectedExecutionHandler {
    public static final String NAME = "custom";
    private RejectedExecutionHandler custom;

    public CustomRejectionPolicy(String rejection_policy) {
        if (!rejection_policy.toLowerCase().startsWith("custom=")) {
            throw new IllegalStateException(rejection_policy);
        }
        String className = rejection_policy.substring(7);
        try {
            Class policyClass = Util.loadClass(className, Util.class);
            Object policy = policyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(policy instanceof RejectedExecutionHandler)) {
                throw new IllegalArgumentException(className + " does not implement RejectedExecutionHandler");
            }
            this.custom = (RejectedExecutionHandler)policy;
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot instantiate rejection policy '" + rejection_policy + "'", e);
        }
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        this.custom.rejectedExecution(r, executor);
    }
}

