/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.ejb._private.Keys;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.transaction.client.AbstractTransaction;

public abstract class AbstractInvocationContext
extends Attachable {
    private final AuthenticationContext authenticationContext;
    private final EJBClientContext ejbClientContext;
    private EJBReceiver receiver;
    private EJBLocator<?> locator;
    private Affinity weakAffinity = Affinity.NONE;
    private URI destination;
    private Affinity targetAffinity;
    private String initialCluster;
    private Map<String, Object> contextData;
    private AbstractTransaction transaction;

    public String getInitialCluster() {
        return this.initialCluster;
    }

    void setInitialCluster(String initialCluster) {
        this.initialCluster = initialCluster;
    }

    AbstractInvocationContext(EJBLocator<?> locator, EJBClientContext ejbClientContext, AuthenticationContext authenticationContext) {
        this.locator = locator;
        this.ejbClientContext = ejbClientContext;
        this.authenticationContext = authenticationContext;
    }

    public AuthenticationContext getAuthenticationContext() {
        AuthenticationContext attached = this.getAttachment(Keys.AUTHENTICATION_CONTEXT_ATTACHMENT_KEY);
        return attached != null ? attached : this.authenticationContext;
    }

    public EJBClientContext getClientContext() {
        return this.ejbClientContext;
    }

    public Map<String, Object> getContextData() {
        Map<String, Object> contextData = this.contextData;
        if (contextData == null) {
            this.contextData = new LinkedHashMap<String, Object>();
            return this.contextData;
        }
        return contextData;
    }

    public EJBLocator<?> getLocator() {
        return this.locator;
    }

    public <T> void setLocator(EJBLocator<T> locator) {
        this.locator = locator;
    }

    public URI getDestination() {
        return this.destination;
    }

    public void setDestination(URI destination) {
        this.destination = destination;
    }

    public Affinity getTargetAffinity() {
        return this.targetAffinity;
    }

    public void setTargetAffinity(Affinity targetAffinity) {
        this.targetAffinity = targetAffinity;
    }

    EJBReceiver getReceiver() {
        return this.receiver;
    }

    void setReceiver(EJBReceiver receiver) {
        this.receiver = receiver;
    }

    public Affinity getWeakAffinity() {
        return this.weakAffinity;
    }

    public void setWeakAffinity(Affinity weakAffinity) {
        Assert.checkNotNullParam("weakAffinity", weakAffinity);
        this.weakAffinity = weakAffinity;
    }

    public Class<?> getViewClass() {
        return this.locator.getViewType();
    }

    public abstract void requestRetry();

    public AbstractTransaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(AbstractTransaction transaction) {
        this.transaction = transaction;
    }
}

