/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.NoSuchElementException;

final class StringIterator {
    private final String string;
    private int idx;

    StringIterator(String string) {
        this.string = string;
    }

    boolean hasNext() {
        return this.idx < this.string.length();
    }

    int next() {
        if (!this.hasNext()) {
            throw this.unexpectedEnd();
        }
        try {
            int n = this.string.codePointAt(this.idx);
            return n;
        }
        finally {
            this.idx = this.string.offsetByCodePoints(this.idx, 1);
        }
    }

    int peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.string.codePointAt(this.idx);
    }

    int getOffset() {
        return this.idx;
    }

    IllegalArgumentException unexpectedCharacter() {
        return new IllegalArgumentException("Unexpected character at " + this.string.offsetByCodePoints(this.idx, -1));
    }

    IllegalArgumentException unexpectedEnd() {
        return new IllegalArgumentException("Unexpected end of string");
    }
}

