/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import org.jboss.threads.DirectExecutor;

class ContextClassLoaderExecutor
implements DirectExecutor {
    private final ClassLoader taskClassLoader;
    private final DirectExecutor delegate;

    ContextClassLoaderExecutor(ClassLoader taskClassLoader, DirectExecutor delegate) {
        this.taskClassLoader = taskClassLoader;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        Thread thr = Thread.currentThread();
        ClassLoader old = thr.getContextClassLoader();
        thr.setContextClassLoader(this.taskClassLoader);
        try {
            this.delegate.execute(command);
        }
        finally {
            thr.setContextClassLoader(old);
        }
    }

    public String toString() {
        return String.format("%s (classloader %s) -> %s", super.toString(), this.taskClassLoader, this.delegate);
    }
}

