/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.PathTemplateMatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Deque;
import java.util.function.Function;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.ElytronIdentityHandler;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpServerHelper;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.common.NoFlushByteOutput;
import org.wildfly.httpclient.naming.HttpNamingClientMessages;
import org.wildfly.httpclient.naming.NamingConstants;

public class HttpRemoteNamingService {
    private final Context localContext;
    private final Function<String, Boolean> classResolverFilter;
    private final HttpServiceConfig httpServiceConfig;

    @Deprecated
    public HttpRemoteNamingService(Context localContext) {
        this(localContext, HttpServiceConfig.getInstance(), null);
    }

    public HttpRemoteNamingService(Context localContext, Function<String, Boolean> classResolverFilter) {
        this(localContext, HttpServiceConfig.getInstance(), classResolverFilter);
    }

    HttpRemoteNamingService(Context localContext, HttpServiceConfig httpServiceConfig, Function<String, Boolean> classResolverFilter) {
        this.localContext = localContext;
        this.httpServiceConfig = httpServiceConfig;
        this.classResolverFilter = classResolverFilter;
    }

    public HttpHandler createHandler() {
        RoutingHandler routingHandler = new RoutingHandler();
        String nameParamPathSuffix = "/{name}";
        routingHandler.add(Methods.POST, "/lookup/{name}", (HttpHandler)new LookupHandler());
        routingHandler.add(Methods.GET, "/lookuplink/{name}", (HttpHandler)new LookupLinkHandler());
        routingHandler.add(Methods.PUT, "/bind/{name}", (HttpHandler)new BindHandler());
        routingHandler.add(Methods.PATCH, "/rebind/{name}", (HttpHandler)new RebindHandler());
        routingHandler.add(Methods.DELETE, "/unbind/{name}", (HttpHandler)new UnbindHandler());
        routingHandler.add(Methods.DELETE, "/dest-subctx/{name}", (HttpHandler)new DestroySubcontextHandler());
        routingHandler.add(Methods.GET, "/list/{name}", (HttpHandler)new ListHandler());
        routingHandler.add(Methods.GET, "/list-bindings/{name}", (HttpHandler)new ListBindingsHandler());
        routingHandler.add(Methods.PATCH, "/rename/{name}", (HttpHandler)new RenameHandler());
        routingHandler.add(Methods.PUT, "/create-subcontext/{name}", (HttpHandler)new CreateSubContextHandler());
        return this.httpServiceConfig.wrap(new BlockingHandler(new ElytronIdentityHandler(routingHandler)));
    }

    private void doMarshall(HttpServerExchange exchange, Object result) throws IOException {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, NamingConstants.VALUE.toString());
        Marshaller marshaller = this.httpServiceConfig.getHttpMarshallerFactory(exchange).createMarshaller();
        marshaller.start(new NoFlushByteOutput(Marshalling.createByteOutput(exchange.getOutputStream())));
        marshaller.writeObject(result);
        marshaller.finish();
        marshaller.flush();
    }

    @Deprecated
    public static void sendException(HttpServerExchange exchange, int status, Throwable e) throws IOException {
        HttpServerHelper.sendException(exchange, HttpServiceConfig.getInstance(), status, e);
    }

    public static void sendException(HttpServerExchange exchange, HttpServiceConfig httpServiceConfig, int status, Throwable e) throws IOException {
        HttpServerHelper.sendException(exchange, httpServiceConfig, status, e);
    }

    private static class FilterClassResolver
    extends ContextClassResolver {
        private final Function<String, Boolean> filter;

        private FilterClassResolver(Function<String, Boolean> filter) {
            this.filter = filter;
        }

        @Override
        public Class<?> resolveClass(Unmarshaller unmarshaller, String name, long serialVersionUID) throws IOException, ClassNotFoundException {
            this.checkFilter(name);
            return super.resolveClass(unmarshaller, name, serialVersionUID);
        }

        @Override
        public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
            for (String name : interfaces) {
                this.checkFilter(name);
            }
            return super.resolveProxyClass(unmarshaller, interfaces);
        }

        private void checkFilter(String className) throws InvalidClassException {
            if (this.filter.apply(className) != Boolean.TRUE) {
                throw HttpNamingClientMessages.MESSAGES.cannotResolveFilteredClass(className);
            }
        }
    }

    private class BindHandler
    extends NameHandler {
        private BindHandler() {
        }

        @Override
        protected final Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            ContentType contentType = ContentType.parse(exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE));
            if (contentType == null || !contentType.getType().equals(NamingConstants.VALUE.getType()) || contentType.getVersion() != 1) {
                exchange.setStatusCode(400);
                exchange.endExchange();
                return null;
            }
            HttpMarshallerFactory marshallerFactory = HttpRemoteNamingService.this.httpServiceConfig.getHttpUnmarshallerFactory(exchange);
            try (InputStream inputStream = exchange.getInputStream();){
                Unmarshaller unmarshaller = HttpRemoteNamingService.this.classResolverFilter != null ? marshallerFactory.createUnmarshaller(new FilterClassResolver(HttpRemoteNamingService.this.classResolverFilter)) : marshallerFactory.createUnmarshaller();
                unmarshaller.start(new InputStreamByteInput(inputStream));
                Object object = unmarshaller.readObject();
                unmarshaller.finish();
                this.doOperation(name, object);
            }
            catch (Exception e) {
                if (e instanceof NamingException) {
                    throw (NamingException)e;
                }
                NamingException nm = new NamingException(e.getMessage());
                nm.initCause(e);
                throw nm;
            }
            return null;
        }

        protected void doOperation(String name, Object object) throws NamingException {
            HttpRemoteNamingService.this.localContext.bind(name, object);
        }
    }

    private class RebindHandler
    extends BindHandler {
        private RebindHandler() {
        }

        @Override
        protected void doOperation(String name, Object object) throws NamingException {
            HttpRemoteNamingService.this.localContext.rebind(name, object);
        }
    }

    private class ListHandler
    extends NameHandler {
        private ListHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            NamingEnumeration<NameClassPair> namingEnumeration = HttpRemoteNamingService.this.localContext.list(name);
            return Collections.list(namingEnumeration);
        }
    }

    private class DestroySubcontextHandler
    extends NameHandler {
        private DestroySubcontextHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            HttpRemoteNamingService.this.localContext.destroySubcontext(name);
            return null;
        }
    }

    private class RenameHandler
    extends NameHandler {
        private RenameHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            Deque<String> newName = exchange.getQueryParameters().get("new");
            if (newName == null || newName.isEmpty()) {
                exchange.setStatusCode(400);
                exchange.endExchange();
                return null;
            }
            try {
                String nn = URLDecoder.decode(newName.getFirst(), StandardCharsets.UTF_8.name());
                HttpRemoteNamingService.this.localContext.rename(name, nn);
                return null;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ListBindingsHandler
    extends NameHandler {
        private ListBindingsHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            NamingEnumeration<Binding> namingEnumeration = HttpRemoteNamingService.this.localContext.listBindings(name);
            return Collections.list(namingEnumeration);
        }
    }

    private class UnbindHandler
    extends NameHandler {
        private UnbindHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            HttpRemoteNamingService.this.localContext.unbind(name);
            return null;
        }
    }

    private class CreateSubContextHandler
    extends NameHandler {
        private CreateSubContextHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.createSubcontext(name);
        }
    }

    private final class LookupLinkHandler
    extends NameHandler {
        private LookupLinkHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.lookupLink(name);
        }
    }

    private final class LookupHandler
    extends NameHandler {
        private LookupHandler() {
        }

        @Override
        protected Object doOperation(HttpServerExchange exchange, String name) throws NamingException {
            return HttpRemoteNamingService.this.localContext.lookup(name);
        }
    }

    private abstract class NameHandler
    implements HttpHandler {
        private NameHandler() {
        }

        @Override
        public final void handleRequest(HttpServerExchange exchange) throws Exception {
            PathTemplateMatch params = exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY);
            String name = URLDecoder.decode(params.getParameters().get("name"), StandardCharsets.UTF_8.name());
            try {
                Object result = this.doOperation(exchange, name);
                if (exchange.isComplete()) {
                    return;
                }
                if (result == null) {
                    exchange.setStatusCode(200);
                } else if (result instanceof Context) {
                    exchange.setStatusCode(204);
                } else {
                    HttpRemoteNamingService.this.doMarshall(exchange, result);
                }
            }
            catch (Throwable e) {
                HttpRemoteNamingService.sendException(exchange, HttpRemoteNamingService.this.httpServiceConfig, 500, e);
            }
        }

        protected abstract Object doOperation(HttpServerExchange var1, String var2) throws NamingException;
    }
}

