/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.ContinueNotification;
import io.undertow.client.PushCallback;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.jboss.marshalling.ClassNameTransformer;
import org.wildfly.httpclient.common.HeadersHelper;
import org.wildfly.httpclient.common.HostPool;
import org.wildfly.httpclient.common.HttpClientMessages;
import org.wildfly.httpclient.common.HttpConnectionPool;
import org.wildfly.httpclient.common.HttpConnectionPoolFactory;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpMarshallerFactoryProvider;
import org.wildfly.httpclient.common.Protocol;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

final class EENamespaceInteroperability {
    static final boolean EE_NAMESPACE_INTEROPERABLE_MODE = Boolean.parseBoolean(WildFlySecurityManager.getPropertyPrivileged("org.wildfly.ee.namespace.interop", "false"));
    private static final HttpString PROTOCOL_VERSION = new HttpString("x-wf-version");
    private static final String LATEST_VERSION = String.valueOf(Protocol.LATEST);
    private static final AttachmentKey<HttpMarshallerFactory> HTTP_MARSHALLER_FACTORY_KEY = AttachmentKey.create(HttpMarshallerFactory.class);
    private static final AttachmentKey<HttpMarshallerFactory> HTTP_UNMARSHALLER_FACTORY_KEY = AttachmentKey.create(HttpMarshallerFactory.class);
    private static final HttpMarshallerFactory INTEROPERABLE_MARSHALLER_FACTORY = new HttpMarshallerFactory(ClassNameTransformer.JAVAEE_TO_JAKARTAEE);

    private EENamespaceInteroperability() {
    }

    static HttpHandler createInteroperabilityHandler(HttpHandler httpHandler) {
        return EENamespaceInteroperability.createProtocolVersionHttpHandler(new EENamespaceInteroperabilityHandler(httpHandler), new JakartaNamespaceHandler(httpHandler));
    }

    static HttpHandler createProtocolVersionHttpHandler(HttpHandler interoperabilityHandler, HttpHandler latestProtocolHandler) {
        PathHandler versionPathHandler = new PathHandler();
        versionPathHandler.addPrefixPath("/v1", interoperabilityHandler);
        versionPathHandler.addPrefixPath("/v2", latestProtocolHandler);
        return versionPathHandler;
    }

    static HttpMarshallerFactoryProvider getHttpMarshallerFactoryProvider() {
        return new HttpMarshallerFactoryProvider(){

            @Override
            public HttpMarshallerFactory getMarshallerFactory(AbstractAttachable attachable) {
                return attachable.getAttachment(HTTP_MARSHALLER_FACTORY_KEY);
            }

            @Override
            public HttpMarshallerFactory getUnmarshallerFactory(AbstractAttachable attachable) {
                return attachable.getAttachment(HTTP_UNMARSHALLER_FACTORY_KEY);
            }
        };
    }

    static HttpConnectionPoolFactory getHttpConnectionPoolFactory() {
        return HttpConnectionPool::new;
    }

    static {
        if (EE_NAMESPACE_INTEROPERABLE_MODE) {
            HttpClientMessages.MESSAGES.javaeeToJakartaeeBackwardCompatibilityLayerInstalled();
        }
    }

    private static class JakartaNamespaceHandler
    implements HttpHandler {
        private final HttpHandler next;

        JakartaNamespaceHandler(HttpHandler next) {
            this.next = next;
        }

        @Override
        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.putAttachment(HTTP_UNMARSHALLER_FACTORY_KEY, HttpMarshallerFactory.DEFAULT_FACTORY);
            exchange.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, HttpMarshallerFactory.DEFAULT_FACTORY);
            this.next.handleRequest(exchange);
        }
    }

    private static class EENamespaceInteroperabilityHandler
    implements HttpHandler {
        private final HttpHandler next;

        EENamespaceInteroperabilityHandler(HttpHandler next) {
            this.next = next;
        }

        @Override
        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (LATEST_VERSION.equals(HeadersHelper.getRequestHeader(exchange, PROTOCOL_VERSION))) {
                HeadersHelper.addResponseHeader(exchange, PROTOCOL_VERSION, LATEST_VERSION);
                exchange.putAttachment(HTTP_UNMARSHALLER_FACTORY_KEY, INTEROPERABLE_MARSHALLER_FACTORY);
                exchange.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, HttpMarshallerFactory.DEFAULT_FACTORY);
            } else {
                exchange.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, INTEROPERABLE_MARSHALLER_FACTORY);
                exchange.putAttachment(HTTP_UNMARSHALLER_FACTORY_KEY, INTEROPERABLE_MARSHALLER_FACTORY);
            }
            this.next.handleRequest(exchange);
        }
    }

    private static class HttpConnectionPool
    extends org.wildfly.httpclient.common.HttpConnectionPool {
        private volatile int protocolVersion = -1;

        protected HttpConnectionPool(int maxConnections, int maxStreamsPerConnection, XnioWorker worker, ByteBufferPool byteBufferPool, OptionMap options, HostPool hostPool, long connectionIdleTimeout) {
            super(maxConnections, maxStreamsPerConnection, worker, byteBufferPool, options, hostPool, connectionIdleTimeout);
        }

        @Override
        int getProtocolVersion() {
            return this.protocolVersion == -1 ? 1 : this.protocolVersion;
        }

        @Override
        protected HttpConnectionPool.ClientConnectionHolder createClientConnectionHolder(ClientConnection connection, URI uri, SSLContext sslContext) {
            return new ClientConnectionHolder(connection, uri, sslContext);
        }

        protected class ClientConnectionHolder
        extends HttpConnectionPool.ClientConnectionHolder {
            private ClientConnectionHolder(ClientConnection connection, URI uri, SSLContext sslContext) {
                super(HttpConnectionPool.this, connection, uri, sslContext);
            }

            @Override
            public void sendRequest(ClientRequest request, final ClientCallback<ClientExchange> callback) {
                switch (HttpConnectionPool.this.protocolVersion) {
                    case -1: {
                        HeadersHelper.putRequestHeader(request, PROTOCOL_VERSION, LATEST_VERSION);
                        request.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, INTEROPERABLE_MARSHALLER_FACTORY);
                        break;
                    }
                    case 1: {
                        request.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, INTEROPERABLE_MARSHALLER_FACTORY);
                        break;
                    }
                    default: {
                        HeadersHelper.putRequestHeader(request, PROTOCOL_VERSION, LATEST_VERSION);
                        request.putAttachment(HTTP_MARSHALLER_FACTORY_KEY, HttpMarshallerFactory.DEFAULT_FACTORY);
                    }
                }
                super.sendRequest(request, new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(ClientExchange result) {
                        callback.completed(new EEInteroperableClientExchange(result));
                    }

                    @Override
                    public void failed(IOException e) {
                        callback.failed(e);
                    }
                });
            }

            private final class EEInteroperableClientExchange
            implements ClientExchange {
                private final ClientExchange wrappedExchange;

                public EEInteroperableClientExchange(ClientExchange clientExchange) {
                    this.wrappedExchange = clientExchange;
                }

                @Override
                public void setResponseListener(final ClientCallback<ClientExchange> responseListener) {
                    this.wrappedExchange.setResponseListener(new ClientCallback<ClientExchange>(){

                        @Override
                        public void completed(ClientExchange result) {
                            ClientResponse response = result.getResponse();
                            if (HttpConnectionPool.this.protocolVersion == -1) {
                                if (LATEST_VERSION.equals(HeadersHelper.getResponseHeader(response, PROTOCOL_VERSION))) {
                                    HttpConnectionPool.this.protocolVersion = Protocol.LATEST;
                                    result.getRequest().putAttachment(HTTP_MARSHALLER_FACTORY_KEY, HttpMarshallerFactory.DEFAULT_FACTORY);
                                } else {
                                    HttpConnectionPool.this.protocolVersion = 1;
                                }
                            }
                            responseListener.completed(result);
                        }

                        @Override
                        public void failed(IOException e) {
                            responseListener.failed(e);
                        }
                    });
                }

                @Override
                public void setContinueHandler(ContinueNotification continueHandler) {
                    this.wrappedExchange.setContinueHandler(continueHandler);
                }

                @Override
                public void setPushHandler(PushCallback pushCallback) {
                    this.wrappedExchange.setPushHandler(pushCallback);
                }

                @Override
                public StreamSinkChannel getRequestChannel() {
                    return this.wrappedExchange.getRequestChannel();
                }

                @Override
                public StreamSourceChannel getResponseChannel() {
                    return this.wrappedExchange.getResponseChannel();
                }

                @Override
                public ClientRequest getRequest() {
                    return this.wrappedExchange.getRequest();
                }

                @Override
                public ClientResponse getResponse() {
                    return this.wrappedExchange.getResponse();
                }

                @Override
                public ClientResponse getContinueResponse() {
                    return this.wrappedExchange.getContinueResponse();
                }

                @Override
                public ClientConnection getConnection() {
                    return this.wrappedExchange.getConnection();
                }

                @Override
                public <T> T getAttachment(AttachmentKey<T> key) {
                    return this.wrappedExchange.getAttachment(key);
                }

                @Override
                public <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
                    return this.wrappedExchange.getAttachmentList(key);
                }

                @Override
                public <T> T putAttachment(AttachmentKey<T> key, T value) {
                    return this.wrappedExchange.putAttachment(key, value);
                }

                @Override
                public <T> T removeAttachment(AttachmentKey<T> key) {
                    return this.wrappedExchange.removeAttachment(key);
                }

                @Override
                public <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
                    this.wrappedExchange.addToAttachmentList(key, value);
                }
            }
        }
    }
}

