/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import javax.transaction.xa.Xid;

final class TransactionInfo {
    static byte NULL_TRANSACTION = 0;
    static byte REMOTE_TRANSACTION = 1;
    static byte LOCAL_TRANSACTION = (byte)2;
    private static final int UNDEFINED = 0;
    private static final TransactionInfo NULL = new TransactionInfo(NULL_TRANSACTION, null, 0);
    private final byte type;
    private final Xid xid;
    private final int remainingTime;

    private TransactionInfo(byte type, Xid xid, int remainingTime) {
        this.type = type;
        this.xid = xid;
        this.remainingTime = remainingTime;
    }

    byte getType() {
        return this.type;
    }

    Xid getXid() {
        return this.xid;
    }

    int getRemainingTime() {
        return this.remainingTime;
    }

    static TransactionInfo nullTransaction() {
        return NULL;
    }

    static TransactionInfo remoteTransaction(Xid xid) {
        return new TransactionInfo(REMOTE_TRANSACTION, xid, 0);
    }

    static TransactionInfo localTransaction(Xid xid, int remainingTime) {
        return new TransactionInfo(LOCAL_TRANSACTION, xid, remainingTime);
    }
}

