/*
    * THIS IS A GENERATED FILE! DO NOT EDIT IT DIRECTLY!

      To see how this file is generated, please refer to
      hornetq-core-client/src/main/resources/hqDefaults.xsl

      To add new entries either document them in the hornetq-configuration.xsd by adding:

      1. a default value to the schema element (using the standard way of adding a default)
      2. adding a hq:field_name attribute to a xsd:annotation element of the element in question.

      It is probably easier to just go to the hornetq-configuration.xsd and see how this is done for
      other values, and then copy it.

      The advantage of adding the default to the schema is that:

      a. the schema will inform users of it (for users that check such things through the schema,
      think of XML editors as users...);

      b. the manual gets an entry for it automatically;

      c. the Java code gets the same value;

      d. all 3 sources of defaults will match since they take the value from the same place
      (i.e. the schema).

    */

/*
      XSLT Version = 2.0
      XSLT Vendor = SAXON 8.7 from Saxonica
      XSLT Vendor URL = http://www.saxonica.com/
*/
    package org.hornetq.api.config;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.impl.JournalConstants;

/**
 * Default values of HornetQ configuration parameters.
 */
public final class HornetQDefaultConfiguration
{
   /*
    * <p> In order to avoid compile time in-lining of constants, all access is done through methods
    * and all fields are PRIVATE STATIC but not FINAL. This is done following the recommendation at
    * <a href="http://docs.oracle.com/javase/specs/jls/se7/html/jls-13.html#jls-13.4.9">13.4.9.
    * final Fields and Constants</a>
    * @see http://docs.oracle.com/javase/specs/jls/se7/html/jls-13.html#jls-13.4.9
    */

   private HornetQDefaultConfiguration()
   {
      // Utility class
   }

   public static long getDefaultClientFailureCheckPeriod()
   {
      return DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
   }

   public static long getDefaultFileDeployerScanPeriod()
   {
      return DEFAULT_FILE_DEPLOYER_SCAN_PERIOD;
   }

   public static int getDefaultJournalMaxIoAio()
   {
      return DEFAULT_JOURNAL_MAX_IO_AIO;
   }

   public static int getDefaultJournalBufferTimeoutAio()
   {
      return DEFAULT_JOURNAL_BUFFER_TIMEOUT_AIO;
   }

   public static int getDefaultJournalBufferSizeAio()
   {
      return DEFAULT_JOURNAL_BUFFER_SIZE_AIO;
   }

   public static int getDefaultJournalMaxIoNio()
   {
      return DEFAULT_JOURNAL_MAX_IO_NIO;
   }

   public static int getDefaultJournalBufferTimeoutNio()
   {
      return DEFAULT_JOURNAL_BUFFER_TIMEOUT_NIO;
   }

   public static int getDefaultJournalBufferSizeNio()
   {
      return DEFAULT_JOURNAL_BUFFER_SIZE_NIO;
   }

   public static String getPropMaskPassword()
   {
      return PROP_MASK_PASSWORD;
   }

   public static String getPropPasswordCodec()
   {
      return PROP_PASSWORD_CODEC;
   }

   //shared by client and core/server
   // XXX not on schema?
   private static long DEFAULT_CLIENT_FAILURE_CHECK_PERIOD = 30000;

   // XXX not on schema?
   private static long DEFAULT_FILE_DEPLOYER_SCAN_PERIOD = 5000;

   // These defaults are applied depending on whether the journal type
   // is NIO or AIO.
   private static int DEFAULT_JOURNAL_MAX_IO_AIO = 500;
   private static int DEFAULT_JOURNAL_BUFFER_TIMEOUT_AIO = JournalConstants.DEFAULT_JOURNAL_BUFFER_TIMEOUT_AIO;
   private static int DEFAULT_JOURNAL_BUFFER_SIZE_AIO = JournalConstants.DEFAULT_JOURNAL_BUFFER_SIZE_AIO;
   private static int DEFAULT_JOURNAL_MAX_IO_NIO = 1;
   private static int DEFAULT_JOURNAL_BUFFER_TIMEOUT_NIO = JournalConstants.DEFAULT_JOURNAL_BUFFER_TIMEOUT_NIO;
   private static int DEFAULT_JOURNAL_BUFFER_SIZE_NIO = JournalConstants.DEFAULT_JOURNAL_BUFFER_SIZE_NIO;

   // XXX not on schema.
   //properties passed to acceptor/connectors.
   private static String PROP_MASK_PASSWORD = "hornetq.usemaskedpassword";
   private static String PROP_PASSWORD_CODEC = "hornetq.passwordcodec";

    // -------------------------------------------------------------------
    // Following fields are generated from the hornetq-schema.xsd annotations
    // -------------------------------------------------------------------

   // If true then the HornetQ Server will make use of any Protocol Managers that are in available on the classpath. If false then only the core protocol will be available, unless in Embedded mode where users can inject their own Protocol Managers.
   private static boolean DEFAULT_RESOLVE_PROTOCOLS = true;

   // Whether to check the cluster for a (live) server using our own server ID when starting up. This option is only necessary for performing 'fail-back' on replicating servers. Strictly speaking this setting only applies to live servers and not to backups.
   private static boolean DEFAULT_CHECK_FOR_LIVE_SERVER = false;

   // true means that the server will load configuration from the configuration files
   private static boolean DEFAULT_FILE_DEPLOYMENT_ENABLED = false;

   // true means that the server will use the file based journal for persistence.
   private static boolean DEFAULT_PERSISTENCE_ENABLED = true;

   // Maximum number of threads to use for the scheduled thread pool
   private static int DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE = 5;

   // Maximum number of threads to use for the thread pool. -1 means 'no limits'.
   private static int DEFAULT_THREAD_POOL_MAX_SIZE = 30;

   // true means that security is enabled
   private static boolean DEFAULT_SECURITY_ENABLED = true;

   // how long (in ms) to wait before invalidating the security cache
   private static long DEFAULT_SECURITY_INVALIDATION_INTERVAL = 10000;

   // true means that the server supports wild card routing
   private static boolean DEFAULT_WILDCARD_ROUTING_ENABLED = true;

   // the name of the management address to send management messages to. It is prefixed with "jms.queue" so that JMS clients can send messages to it.
   private static SimpleString DEFAULT_MANAGEMENT_ADDRESS = new SimpleString("jms.queue.hornetq.management");

   // the name of the address that consumers bind to receive management notifications
   private static SimpleString DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS = new SimpleString("hornetq.notifications");

   // Cluster username. It applies to all cluster configurations.
   private static String DEFAULT_CLUSTER_USER = "HORNETQ.CLUSTER.ADMIN.USER";

   // Cluster password. It applies to all cluster configurations.
   private static String DEFAULT_CLUSTER_PASSWORD = "CHANGE ME!!";

   // This specifies how many times a replicated backup server can restart after moving its files on start. Once there are this number of backup journal files the server will stop permanently after if fails back.
   private static int DEFAULT_MAX_SAVED_REPLICATED_JOURNALS_SIZE = 2;

   // This option controls whether passwords in server configuration need be masked. If set to "true" the passwords are masked.
   private static boolean DEFAULT_MASK_PASSWORD = false;

   // true means that the management API is available via JMX
   private static boolean DEFAULT_JMX_MANAGEMENT_ENABLED = true;

   // the JMX domain used to registered HornetQ MBeans in the MBeanServer
   private static String DEFAULT_JMX_DOMAIN = "org.hornetq";

   // true means that message counters are enabled
   private static boolean DEFAULT_MESSAGE_COUNTER_ENABLED = false;

   // the sample period (in ms) to use for message counters
   private static long DEFAULT_MESSAGE_COUNTER_SAMPLE_PERIOD = 10000;

   // how many days to keep message counter history
   private static int DEFAULT_MESSAGE_COUNTER_MAX_DAY_HISTORY = 10;

   // if set, this will override how long (in ms) to keep a connection alive without receiving a ping. -1 disables this setting.
   private static long DEFAULT_CONNECTION_TTL_OVERRIDE = -1;

   // Should incoming packets on the server be handed off to a thread from the thread pool for processing or should they be handled on the remoting thread?
   private static boolean DEFAULT_ASYNC_CONNECTION_EXECUTION_ENABLED = true;

   // how long (in ms) before a transaction can be removed from the resource manager after create time
   private static long DEFAULT_TRANSACTION_TIMEOUT = 300000;

   // how often (in ms) to scan for timeout transactions
   private static long DEFAULT_TRANSACTION_TIMEOUT_SCAN_PERIOD = 1000;

   // how often (in ms) to scan for expired messages
   private static long DEFAULT_MESSAGE_EXPIRY_SCAN_PERIOD = 30000;

   // the priority of the thread expiring messages
   private static int DEFAULT_MESSAGE_EXPIRY_THREAD_PRIORITY = 3;

   // the size of the cache for pre-creating message ID's
   private static int DEFAULT_ID_CACHE_SIZE = 20000;

   // true means that ID's are persisted to the journal
   private static boolean DEFAULT_PERSIST_ID_CACHE = true;

   // whether this server is a backup server
   private static boolean DEFAULT_BACKUP = false;

   // Whether a server will automatically stop when a another places a request to take over its place. The use case is when a regular server stops and its backup takes over its duties, later the main server restarts and requests the server (the former backup) to stop operating.
   private static boolean DEFAULT_ALLOW_AUTO_FAILBACK = true;

   // delay to wait before fail-back occurs on (live's) restart
   private static long DEFAULT_FAILBACK_DELAY = 5000;

   // Will this backup server come live on a normal server shutdown
   private static boolean DEFAULT_FAILOVER_ON_SERVER_SHUTDOWN = false;

   // 'shared-store' applies to live and backup pairs, and it indicates if the live/backup pair share storage or if the data is replicated among them.
   private static boolean DEFAULT_SHARED_STORE = true;

   // True means that the delivery count is persisted before delivery. False means that this only happens after a message has been cancelled.
   private static boolean DEFAULT_PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY = false;

   // the directory to store paged messages in
   private static String DEFAULT_PAGING_DIR = "data/paging";

   // the directory to store the persisted bindings to
   private static String DEFAULT_BINDINGS_DIRECTORY = "data/bindings";

   // true means that the server will create the bindings directory on start up
   private static boolean DEFAULT_CREATE_BINDINGS_DIR = true;

   // The max number of concurrent reads allowed on paging
   private static int DEFAULT_MAX_CONCURRENT_PAGE_IO = 5;

   // the directory to store the journal files in
   private static String DEFAULT_JOURNAL_DIR = "data/journal";

   // true means that the journal directory will be created
   private static boolean DEFAULT_CREATE_JOURNAL_DIR = true;

   // if true wait for transaction data to be synchronized to the journal before returning response to client
   private static boolean DEFAULT_JOURNAL_SYNC_TRANSACTIONAL = true;

   // if true wait for non transaction data to be synced to the journal before returning response to client.
   private static boolean DEFAULT_JOURNAL_SYNC_NON_TRANSACTIONAL = true;

   // Whether to log messages about the journal write rate
   private static boolean DEFAULT_JOURNAL_LOG_WRITE_RATE = false;

   // the size (in bytes) of each journal file
   private static int DEFAULT_JOURNAL_FILE_SIZE = 10485760;

   // how many journal files to pre-create
   private static int DEFAULT_JOURNAL_MIN_FILES = 2;

   // The percentage of live data on which we consider compacting the journal
   private static int DEFAULT_JOURNAL_COMPACT_PERCENTAGE = 30;

   // The minimal number of data files before we can start compacting
   private static int DEFAULT_JOURNAL_COMPACT_MIN_FILES = 10;

   // XXX Only meant to be used by project developers
   private static int DEFAULT_JOURNAL_PERF_BLAST_PAGES = -1;

   // XXX Only meant to be used by project developers
   private static boolean DEFAULT_RUN_SYNC_SPEED_TEST = false;

   // Interval to log server specific information (e.g. memory usage etc)
   private static long DEFAULT_SERVER_DUMP_INTERVAL = -1;

   // Percentage of available memory which will trigger a warning log
   private static int DEFAULT_MEMORY_WARNING_THRESHOLD = 25;

   // frequency to sample JVM memory in ms (or -1 to disable memory sampling)
   private static long DEFAULT_MEMORY_MEASURE_INTERVAL = -1;

   // the directory to store large messages
   private static String DEFAULT_LARGE_MESSAGES_DIR = "data/largemessages";

   // period in milliseconds between consecutive broadcasts
   private static long DEFAULT_BROADCAST_PERIOD = 2000;

   // Period the discovery group waits after receiving the last broadcast from a particular server before removing that servers connector pair entry from its list.
   private static int DEFAULT_BROADCAST_REFRESH_TIMEOUT = 10000;

   // how long to keep a connection alive in the absence of any data arriving from the client. This should be greater than the ping period.
   private static long DEFAULT_CONNECTION_TTL = 60000;

   // multiplier to apply to successive retry intervals
   private static double DEFAULT_RETRY_INTERVAL_MULTIPLIER = 1;

   // Limit to the retry-interval growth (due to retry-interval-multiplier)
   private static long DEFAULT_MAX_RETRY_INTERVAL = 2000;

   // maximum number of initial connection attempts, -1 means 'no limits'
   private static int DEFAULT_BRIDGE_INITIAL_CONNECT_ATTEMPTS = -1;

   // maximum number of retry attempts, -1 means 'no limits'
   private static int DEFAULT_BRIDGE_RECONNECT_ATTEMPTS = -1;

   // should duplicate detection headers be inserted in forwarded messages?
   private static boolean DEFAULT_BRIDGE_DUPLICATE_DETECTION = true;

   // Upon reconnection this configures the number of time the same node on the topology will be retried before reseting the server locator and using the initial connectors
   private static int DEFAULT_BRIDGE_CONNECT_SAME_NODE = 10;

   // The period (in milliseconds) used to check if the cluster connection has failed to receive pings from another server
   private static long DEFAULT_CLUSTER_FAILURE_CHECK_PERIOD = 30000;

   // how long to keep a connection alive in the absence of any data arriving from the client
   private static long DEFAULT_CLUSTER_CONNECTION_TTL = 60000;

   // period (in ms) between successive retries
   private static long DEFAULT_CLUSTER_RETRY_INTERVAL = 500;

   // multiplier to apply to the retry-interval
   private static double DEFAULT_CLUSTER_RETRY_INTERVAL_MULTIPLIER = 1;

   // Maximum value for retry-interval
   private static long DEFAULT_CLUSTER_MAX_RETRY_INTERVAL = 2000;

   // How many attempts should be made to connect initially
   private static int DEFAULT_CLUSTER_INITIAL_CONNECT_ATTEMPTS = -1;

   // How many attempts should be made to reconnect after failure
   private static int DEFAULT_CLUSTER_RECONNECT_ATTEMPTS = -1;

   // should duplicate detection headers be inserted in forwarded messages?
   private static boolean DEFAULT_CLUSTER_DUPLICATE_DETECTION = true;

   // should messages be load balanced if there are no matching consumers on target?
   private static boolean DEFAULT_CLUSTER_FORWARD_WHEN_NO_CONSUMERS = false;

   // maximum number of hops cluster topology is propagated
   private static int DEFAULT_CLUSTER_MAX_HOPS = 1;

   // how often the cluster connection will notify the cluster of its existence right after joining the cluster
   private static long DEFAULT_CLUSTER_NOTIFICATION_INTERVAL = 1000;

   // how many times this cluster connection will notify the cluster of its existence right after joining the cluster
   private static int DEFAULT_CLUSTER_NOTIFICATION_ATTEMPTS = 2;

   // whether this is an exclusive divert
   private static boolean DEFAULT_DIVERT_EXCLUSIVE = false;


   /**
    * If true then the HornetQ Server will make use of any Protocol Managers that are in available on the classpath. If false then only the core protocol will be available, unless in Embedded mode where users can inject their own Protocol Managers.
    */
   public static boolean isDefaultResolveProtocols()
   {
     return DEFAULT_RESOLVE_PROTOCOLS;
   }
   /**
    * Whether to check the cluster for a (live) server using our own server ID when starting up. This option is only necessary for performing 'fail-back' on replicating servers. Strictly speaking this setting only applies to live servers and not to backups.
    */
   public static boolean isDefaultCheckForLiveServer()
   {
     return DEFAULT_CHECK_FOR_LIVE_SERVER;
   }
   /**
    * true means that the server will load configuration from the configuration files
    */
   public static boolean isDefaultFileDeploymentEnabled()
   {
     return DEFAULT_FILE_DEPLOYMENT_ENABLED;
   }
   /**
    * true means that the server will use the file based journal for persistence.
    */
   public static boolean isDefaultPersistenceEnabled()
   {
     return DEFAULT_PERSISTENCE_ENABLED;
   }
   /**
    * Maximum number of threads to use for the scheduled thread pool
    */
   public static int getDefaultScheduledThreadPoolMaxSize()
   {
     return DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE;
   }
   /**
    * Maximum number of threads to use for the thread pool. -1 means 'no limits'.
    */
   public static int getDefaultThreadPoolMaxSize()
   {
     return DEFAULT_THREAD_POOL_MAX_SIZE;
   }
   /**
    * true means that security is enabled
    */
   public static boolean isDefaultSecurityEnabled()
   {
     return DEFAULT_SECURITY_ENABLED;
   }
   /**
    * how long (in ms) to wait before invalidating the security cache
    */
   public static long getDefaultSecurityInvalidationInterval()
   {
     return DEFAULT_SECURITY_INVALIDATION_INTERVAL;
   }
   /**
    * true means that the server supports wild card routing
    */
   public static boolean isDefaultWildcardRoutingEnabled()
   {
     return DEFAULT_WILDCARD_ROUTING_ENABLED;
   }
   /**
    * the name of the management address to send management messages to. It is prefixed with "jms.queue" so that JMS clients can send messages to it.
    */
   public static SimpleString getDefaultManagementAddress()
   {
     return DEFAULT_MANAGEMENT_ADDRESS;
   }
   /**
    * the name of the address that consumers bind to receive management notifications
    */
   public static SimpleString getDefaultManagementNotificationAddress()
   {
     return DEFAULT_MANAGEMENT_NOTIFICATION_ADDRESS;
   }
   /**
    * Cluster username. It applies to all cluster configurations.
    */
   public static String getDefaultClusterUser()
   {
     return DEFAULT_CLUSTER_USER;
   }
   /**
    * Cluster password. It applies to all cluster configurations.
    */
   public static String getDefaultClusterPassword()
   {
     return DEFAULT_CLUSTER_PASSWORD;
   }
   /**
    * This specifies how many times a replicated backup server can restart after moving its files on start. Once there are this number of backup journal files the server will stop permanently after if fails back.
    */
   public static int getDefaultMaxSavedReplicatedJournalsSize()
   {
     return DEFAULT_MAX_SAVED_REPLICATED_JOURNALS_SIZE;
   }
   /**
    * This option controls whether passwords in server configuration need be masked. If set to "true" the passwords are masked.
    */
   public static boolean isDefaultMaskPassword()
   {
     return DEFAULT_MASK_PASSWORD;
   }
   /**
    * true means that the management API is available via JMX
    */
   public static boolean isDefaultJmxManagementEnabled()
   {
     return DEFAULT_JMX_MANAGEMENT_ENABLED;
   }
   /**
    * the JMX domain used to registered HornetQ MBeans in the MBeanServer
    */
   public static String getDefaultJmxDomain()
   {
     return DEFAULT_JMX_DOMAIN;
   }
   /**
    * true means that message counters are enabled
    */
   public static boolean isDefaultMessageCounterEnabled()
   {
     return DEFAULT_MESSAGE_COUNTER_ENABLED;
   }
   /**
    * the sample period (in ms) to use for message counters
    */
   public static long getDefaultMessageCounterSamplePeriod()
   {
     return DEFAULT_MESSAGE_COUNTER_SAMPLE_PERIOD;
   }
   /**
    * how many days to keep message counter history
    */
   public static int getDefaultMessageCounterMaxDayHistory()
   {
     return DEFAULT_MESSAGE_COUNTER_MAX_DAY_HISTORY;
   }
   /**
    * if set, this will override how long (in ms) to keep a connection alive without receiving a ping. -1 disables this setting.
    */
   public static long getDefaultConnectionTtlOverride()
   {
     return DEFAULT_CONNECTION_TTL_OVERRIDE;
   }
   /**
    * Should incoming packets on the server be handed off to a thread from the thread pool for processing or should they be handled on the remoting thread?
    */
   public static boolean isDefaultAsyncConnectionExecutionEnabled()
   {
     return DEFAULT_ASYNC_CONNECTION_EXECUTION_ENABLED;
   }
   /**
    * how long (in ms) before a transaction can be removed from the resource manager after create time
    */
   public static long getDefaultTransactionTimeout()
   {
     return DEFAULT_TRANSACTION_TIMEOUT;
   }
   /**
    * how often (in ms) to scan for timeout transactions
    */
   public static long getDefaultTransactionTimeoutScanPeriod()
   {
     return DEFAULT_TRANSACTION_TIMEOUT_SCAN_PERIOD;
   }
   /**
    * how often (in ms) to scan for expired messages
    */
   public static long getDefaultMessageExpiryScanPeriod()
   {
     return DEFAULT_MESSAGE_EXPIRY_SCAN_PERIOD;
   }
   /**
    * the priority of the thread expiring messages
    */
   public static int getDefaultMessageExpiryThreadPriority()
   {
     return DEFAULT_MESSAGE_EXPIRY_THREAD_PRIORITY;
   }
   /**
    * the size of the cache for pre-creating message ID's
    */
   public static int getDefaultIdCacheSize()
   {
     return DEFAULT_ID_CACHE_SIZE;
   }
   /**
    * true means that ID's are persisted to the journal
    */
   public static boolean isDefaultPersistIdCache()
   {
     return DEFAULT_PERSIST_ID_CACHE;
   }
   /**
    * whether this server is a backup server
    */
   public static boolean isDefaultBackup()
   {
     return DEFAULT_BACKUP;
   }
   /**
    * Whether a server will automatically stop when a another places a request to take over its place. The use case is when a regular server stops and its backup takes over its duties, later the main server restarts and requests the server (the former backup) to stop operating.
    */
   public static boolean isDefaultAllowAutoFailback()
   {
     return DEFAULT_ALLOW_AUTO_FAILBACK;
   }
   /**
    * delay to wait before fail-back occurs on (live's) restart
    */
   public static long getDefaultFailbackDelay()
   {
     return DEFAULT_FAILBACK_DELAY;
   }
   /**
    * Will this backup server come live on a normal server shutdown
    */
   public static boolean isDefaultFailoverOnServerShutdown()
   {
     return DEFAULT_FAILOVER_ON_SERVER_SHUTDOWN;
   }
   /**
    * 'shared-store' applies to live and backup pairs, and it indicates if the live/backup pair share storage or if the data is replicated among them.
    */
   public static boolean isDefaultSharedStore()
   {
     return DEFAULT_SHARED_STORE;
   }
   /**
    * True means that the delivery count is persisted before delivery. False means that this only happens after a message has been cancelled.
    */
   public static boolean isDefaultPersistDeliveryCountBeforeDelivery()
   {
     return DEFAULT_PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY;
   }
   /**
    * the directory to store paged messages in
    */
   public static String getDefaultPagingDir()
   {
     return DEFAULT_PAGING_DIR;
   }
   /**
    * the directory to store the persisted bindings to
    */
   public static String getDefaultBindingsDirectory()
   {
     return DEFAULT_BINDINGS_DIRECTORY;
   }
   /**
    * true means that the server will create the bindings directory on start up
    */
   public static boolean isDefaultCreateBindingsDir()
   {
     return DEFAULT_CREATE_BINDINGS_DIR;
   }
   /**
    * The max number of concurrent reads allowed on paging
    */
   public static int getDefaultMaxConcurrentPageIo()
   {
     return DEFAULT_MAX_CONCURRENT_PAGE_IO;
   }
   /**
    * the directory to store the journal files in
    */
   public static String getDefaultJournalDir()
   {
     return DEFAULT_JOURNAL_DIR;
   }
   /**
    * true means that the journal directory will be created
    */
   public static boolean isDefaultCreateJournalDir()
   {
     return DEFAULT_CREATE_JOURNAL_DIR;
   }
   /**
    * if true wait for transaction data to be synchronized to the journal before returning response to client
    */
   public static boolean isDefaultJournalSyncTransactional()
   {
     return DEFAULT_JOURNAL_SYNC_TRANSACTIONAL;
   }
   /**
    * if true wait for non transaction data to be synced to the journal before returning response to client.
    */
   public static boolean isDefaultJournalSyncNonTransactional()
   {
     return DEFAULT_JOURNAL_SYNC_NON_TRANSACTIONAL;
   }
   /**
    * Whether to log messages about the journal write rate
    */
   public static boolean isDefaultJournalLogWriteRate()
   {
     return DEFAULT_JOURNAL_LOG_WRITE_RATE;
   }
   /**
    * the size (in bytes) of each journal file
    */
   public static int getDefaultJournalFileSize()
   {
     return DEFAULT_JOURNAL_FILE_SIZE;
   }
   /**
    * how many journal files to pre-create
    */
   public static int getDefaultJournalMinFiles()
   {
     return DEFAULT_JOURNAL_MIN_FILES;
   }
   /**
    * The percentage of live data on which we consider compacting the journal
    */
   public static int getDefaultJournalCompactPercentage()
   {
     return DEFAULT_JOURNAL_COMPACT_PERCENTAGE;
   }
   /**
    * The minimal number of data files before we can start compacting
    */
   public static int getDefaultJournalCompactMinFiles()
   {
     return DEFAULT_JOURNAL_COMPACT_MIN_FILES;
   }
   /**
    * XXX Only meant to be used by project developers
    */
   public static int getDefaultJournalPerfBlastPages()
   {
     return DEFAULT_JOURNAL_PERF_BLAST_PAGES;
   }
   /**
    * XXX Only meant to be used by project developers
    */
   public static boolean isDefaultRunSyncSpeedTest()
   {
     return DEFAULT_RUN_SYNC_SPEED_TEST;
   }
   /**
    * Interval to log server specific information (e.g. memory usage etc)
    */
   public static long getDefaultServerDumpInterval()
   {
     return DEFAULT_SERVER_DUMP_INTERVAL;
   }
   /**
    * Percentage of available memory which will trigger a warning log
    */
   public static int getDefaultMemoryWarningThreshold()
   {
     return DEFAULT_MEMORY_WARNING_THRESHOLD;
   }
   /**
    * frequency to sample JVM memory in ms (or -1 to disable memory sampling)
    */
   public static long getDefaultMemoryMeasureInterval()
   {
     return DEFAULT_MEMORY_MEASURE_INTERVAL;
   }
   /**
    * the directory to store large messages
    */
   public static String getDefaultLargeMessagesDir()
   {
     return DEFAULT_LARGE_MESSAGES_DIR;
   }
   /**
    * period in milliseconds between consecutive broadcasts
    */
   public static long getDefaultBroadcastPeriod()
   {
     return DEFAULT_BROADCAST_PERIOD;
   }
   /**
    * Period the discovery group waits after receiving the last broadcast from a particular server before removing that servers connector pair entry from its list.
    */
   public static int getDefaultBroadcastRefreshTimeout()
   {
     return DEFAULT_BROADCAST_REFRESH_TIMEOUT;
   }
   /**
    * how long to keep a connection alive in the absence of any data arriving from the client. This should be greater than the ping period.
    */
   public static long getDefaultConnectionTtl()
   {
     return DEFAULT_CONNECTION_TTL;
   }
   /**
    * multiplier to apply to successive retry intervals
    */
   public static double getDefaultRetryIntervalMultiplier()
   {
     return DEFAULT_RETRY_INTERVAL_MULTIPLIER;
   }
   /**
    * Limit to the retry-interval growth (due to retry-interval-multiplier)
    */
   public static long getDefaultMaxRetryInterval()
   {
     return DEFAULT_MAX_RETRY_INTERVAL;
   }
   /**
    * maximum number of initial connection attempts, -1 means 'no limits'
    */
   public static int getDefaultBridgeInitialConnectAttempts()
   {
     return DEFAULT_BRIDGE_INITIAL_CONNECT_ATTEMPTS;
   }
   /**
    * maximum number of retry attempts, -1 means 'no limits'
    */
   public static int getDefaultBridgeReconnectAttempts()
   {
     return DEFAULT_BRIDGE_RECONNECT_ATTEMPTS;
   }
   /**
    * should duplicate detection headers be inserted in forwarded messages?
    */
   public static boolean isDefaultBridgeDuplicateDetection()
   {
     return DEFAULT_BRIDGE_DUPLICATE_DETECTION;
   }
   /**
    * Upon reconnection this configures the number of time the same node on the topology will be retried before reseting the server locator and using the initial connectors
    */
   public static int getDefaultBridgeConnectSameNode()
   {
     return DEFAULT_BRIDGE_CONNECT_SAME_NODE;
   }
   /**
    * The period (in milliseconds) used to check if the cluster connection has failed to receive pings from another server
    */
   public static long getDefaultClusterFailureCheckPeriod()
   {
     return DEFAULT_CLUSTER_FAILURE_CHECK_PERIOD;
   }
   /**
    * how long to keep a connection alive in the absence of any data arriving from the client
    */
   public static long getDefaultClusterConnectionTtl()
   {
     return DEFAULT_CLUSTER_CONNECTION_TTL;
   }
   /**
    * period (in ms) between successive retries
    */
   public static long getDefaultClusterRetryInterval()
   {
     return DEFAULT_CLUSTER_RETRY_INTERVAL;
   }
   /**
    * multiplier to apply to the retry-interval
    */
   public static double getDefaultClusterRetryIntervalMultiplier()
   {
     return DEFAULT_CLUSTER_RETRY_INTERVAL_MULTIPLIER;
   }
   /**
    * Maximum value for retry-interval
    */
   public static long getDefaultClusterMaxRetryInterval()
   {
     return DEFAULT_CLUSTER_MAX_RETRY_INTERVAL;
   }
   /**
    * How many attempts should be made to connect initially
    */
   public static int getDefaultClusterInitialConnectAttempts()
   {
     return DEFAULT_CLUSTER_INITIAL_CONNECT_ATTEMPTS;
   }
   /**
    * How many attempts should be made to reconnect after failure
    */
   public static int getDefaultClusterReconnectAttempts()
   {
     return DEFAULT_CLUSTER_RECONNECT_ATTEMPTS;
   }
   /**
    * should duplicate detection headers be inserted in forwarded messages?
    */
   public static boolean isDefaultClusterDuplicateDetection()
   {
     return DEFAULT_CLUSTER_DUPLICATE_DETECTION;
   }
   /**
    * should messages be load balanced if there are no matching consumers on target?
    */
   public static boolean isDefaultClusterForwardWhenNoConsumers()
   {
     return DEFAULT_CLUSTER_FORWARD_WHEN_NO_CONSUMERS;
   }
   /**
    * maximum number of hops cluster topology is propagated
    */
   public static int getDefaultClusterMaxHops()
   {
     return DEFAULT_CLUSTER_MAX_HOPS;
   }
   /**
    * how often the cluster connection will notify the cluster of its existence right after joining the cluster
    */
   public static long getDefaultClusterNotificationInterval()
   {
     return DEFAULT_CLUSTER_NOTIFICATION_INTERVAL;
   }
   /**
    * how many times this cluster connection will notify the cluster of its existence right after joining the cluster
    */
   public static int getDefaultClusterNotificationAttempts()
   {
     return DEFAULT_CLUSTER_NOTIFICATION_ATTEMPTS;
   }
   /**
    * whether this is an exclusive divert
    */
   public static boolean isDefaultDivertExclusive()
   {
     return DEFAULT_DIVERT_EXCLUSIVE;
   }

}
