/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.controller.Metric;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class MetricHandler<C>
extends AbstractRuntimeOnlyHandler
implements Registration {
    private final Map<String, Metric<C>> metrics = new HashMap<String, Metric<C>>();
    private final MetricExecutor<C> executor;

    public <M extends Enum<M>> MetricHandler(MetricExecutor<C> executor, Class<M> metricClass) {
        this(executor, EnumSet.allOf(metricClass));
    }

    public MetricHandler(MetricExecutor<C> executor, Metric<C>[] metrics) {
        this(executor, Arrays.asList(metrics));
    }

    public MetricHandler(MetricExecutor<C> executor, Iterable<? extends Metric<C>> metrics) {
        this.executor = executor;
        for (Metric<C> metric : metrics) {
            this.metrics.put(((AttributeDefinition)metric.getDefinition()).getName(), metric);
        }
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        for (Metric<C> metric : this.metrics.values()) {
            registration.registerReadOnlyAttribute((AttributeDefinition)metric.getDefinition(), (OperationStepHandler)this);
        }
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) {
        String name = Operations.getAttributeName(operation);
        try {
            ModelNode result = this.executor.execute(context, this.metrics.get(name));
            if (result != null) {
                context.getResult().set(result);
            }
        }
        catch (OperationFailedException e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }
}

