/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.dmr.ModelNode;

public final class Operations {
    private static final String INDEX = "index";
    private static final String KEY = "key";

    public static PathAddress getPathAddress(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.require("address"));
    }

    public static void setPathAddress(ModelNode operation, PathAddress address) {
        operation.get("address").set(address.toModelNode());
    }

    public static String getName(ModelNode operation) {
        return operation.require("operation").asString();
    }

    public static String getAttributeName(ModelNode operation) {
        return operation.require("name").asString();
    }

    public static ModelNode getAttributeValue(ModelNode operation) {
        return operation.hasDefined("value") ? operation.get("value") : new ModelNode();
    }

    public static ModelNode createCompositeOperation(List<ModelNode> operations) {
        ModelNode operation = Util.createOperation((String)"composite", (PathAddress)PathAddress.EMPTY_ADDRESS);
        ModelNode steps = operation.get("steps");
        for (ModelNode step : operations) {
            steps.add(step);
        }
        return operation;
    }

    public static ModelNode createCompositeOperation(ModelNode ... operations) {
        return Operations.createCompositeOperation(Arrays.asList(operations));
    }

    public static ModelNode createAddOperation(PathAddress address, Map<Attribute, ModelNode> parameters) {
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        for (Map.Entry<Attribute, ModelNode> entry : parameters.entrySet()) {
            operation.get(((AttributeDefinition)entry.getKey().getDefinition()).getName()).set(entry.getValue());
        }
        return operation;
    }

    public static ModelNode createAddOperation(PathAddress address, int index) {
        return Operations.createAddOperation(address, index, Collections.emptyMap());
    }

    public static ModelNode createAddOperation(PathAddress address, int index, Map<Attribute, ModelNode> parameters) {
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operation.get("add-index").set(index);
        for (Map.Entry<Attribute, ModelNode> entry : parameters.entrySet()) {
            operation.get(((AttributeDefinition)entry.getKey().getDefinition()).getName()).set(entry.getValue());
        }
        return operation;
    }

    public static ModelNode createReadAttributeOperation(PathAddress address, Attribute attribute) {
        return Operations.createAttributeOperation("read-attribute", address, attribute);
    }

    public static ModelNode createWriteAttributeOperation(PathAddress address, Attribute attribute, ModelNode value) {
        ModelNode operation = Operations.createAttributeOperation("write-attribute", address, attribute);
        operation.get("value").set(value);
        return operation;
    }

    public static ModelNode createUndefineAttributeOperation(PathAddress address, Attribute attribute) {
        return Operations.createAttributeOperation("undefine-attribute", address, attribute);
    }

    private static ModelNode createAttributeOperation(String operationName, PathAddress address, Attribute attribute) {
        ModelNode operation = Util.createOperation((String)operationName, (PathAddress)address);
        operation.get("name").set(((AttributeDefinition)attribute.getDefinition()).getName());
        return operation;
    }

    public static ModelNode createDescribeOperation(PathAddress address) {
        return Util.createOperation((String)"describe", (PathAddress)address);
    }

    public static ModelNode createListAddOperation(PathAddress address, Attribute attribute, String value) {
        return Operations.createListElementOperation(ListOperations.LIST_ADD_DEFINITION, address, attribute, value);
    }

    public static ModelNode createListRemoveOperation(PathAddress address, Attribute attribute, String value) {
        return Operations.createListElementOperation(ListOperations.LIST_REMOVE_DEFINITION, address, attribute, value);
    }

    public static ModelNode createListRemoveOperation(PathAddress address, Attribute attribute, int index) {
        return Operations.createListElementOperation(ListOperations.LIST_REMOVE_DEFINITION, address, attribute, index);
    }

    public static ModelNode createListGetOperation(PathAddress address, Attribute attribute, int index) {
        return Operations.createListElementOperation(ListOperations.LIST_GET_DEFINITION, address, attribute, index);
    }

    private static ModelNode createListElementOperation(OperationDefinition definition, PathAddress address, Attribute attribute, String value) {
        ModelNode operation = Operations.createAttributeOperation(definition.getName(), address, attribute);
        operation.get("value").set(value);
        return operation;
    }

    private static ModelNode createListElementOperation(OperationDefinition definition, PathAddress address, Attribute attribute, int index) {
        ModelNode operation = Operations.createAttributeOperation(definition.getName(), address, attribute);
        operation.get(INDEX).set(new ModelNode(index));
        return operation;
    }

    public static ModelNode createMapGetOperation(PathAddress address, Attribute attribute, String key) {
        return Operations.createMapEntryOperation(MapOperations.MAP_GET_DEFINITION, address, attribute, key);
    }

    public static ModelNode createMapPutOperation(PathAddress address, Attribute attribute, String key, String value) {
        ModelNode operation = Operations.createMapEntryOperation(MapOperations.MAP_PUT_DEFINITION, address, attribute, key);
        operation.get("value").set(value);
        return operation;
    }

    public static ModelNode createMapRemoveOperation(PathAddress address, Attribute attribute, String key) {
        return Operations.createMapEntryOperation(MapOperations.MAP_REMOVE_DEFINITION, address, attribute, key);
    }

    private static ModelNode createMapEntryOperation(OperationDefinition definition, PathAddress address, Attribute attribute, String key) {
        ModelNode operation = Operations.createAttributeOperation(definition.getName(), address, attribute);
        operation.get(KEY).set(key);
        return operation;
    }

    private Operations() {
    }
}

