/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.descriptions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;

public class SubsystemResourceDescriptionResolver
extends StandardResourceDescriptionResolver {
    private static final String RESOURCE_NAME_PATTERN = "%s.LocalDescriptions";
    private final String subsystemName;
    private final List<PathElement> paths;

    protected SubsystemResourceDescriptionResolver(String subsystemName, Class<? extends Extension> extensionClass) {
        this(subsystemName, extensionClass, Collections.emptyList());
    }

    protected SubsystemResourceDescriptionResolver(String subsystemName, Class<? extends Extension> extensionClass, PathElement ... paths) {
        this(subsystemName, extensionClass, Arrays.asList(paths));
    }

    protected SubsystemResourceDescriptionResolver(String subsystemName, Class<? extends Extension> extensionClass, List<PathElement> paths) {
        super(paths.isEmpty() ? subsystemName : SubsystemResourceDescriptionResolver.getBundleKey(subsystemName, paths.get(0)), String.format(RESOURCE_NAME_PATTERN, extensionClass.getPackage().getName()), extensionClass.getClassLoader(), true, false);
        this.subsystemName = subsystemName;
        this.paths = paths;
    }

    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, attributeName, new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getResourceAttributeDescription(attributeName, locale, bundle);
    }

    public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, attributeName, suffixes);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle, suffixes);
    }

    public String getOperationDescription(String operationName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, operationName, new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getOperationDescription(operationName, locale, bundle);
    }

    public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key;
            String[] stringArray;
            if (this.isReuseAttributesForAdd() && operationName.equals("add")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = paramName;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = operationName;
                stringArray = stringArray3;
                stringArray3[1] = paramName;
            }
            if (!bundle.containsKey(key = this.getBundleKey(path, stringArray, new String[0]))) continue;
            return bundle.getString(key);
        }
        return super.getOperationParameterDescription(operationName, paramName, locale, bundle);
    }

    public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        for (PathElement path : this.paths) {
            String key;
            String[] stringArray;
            if (this.isReuseAttributesForAdd() && operationName.equals("add")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = paramName;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = operationName;
                stringArray = stringArray3;
                stringArray3[1] = paramName;
            }
            if (!bundle.containsKey(key = this.getBundleKey(path, stringArray, suffixes))) continue;
            return bundle.getString(key);
        }
        return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle, suffixes);
    }

    public String getOperationReplyDescription(String operationName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, new String[]{operationName, "reply"}, new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getOperationReplyDescription(operationName, locale, bundle);
    }

    public String getOperationReplyValueTypeDescription(String operationName, Locale locale, ResourceBundle bundle, String ... suffixes) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, new String[]{operationName, "reply"}, suffixes);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getOperationReplyValueTypeDescription(operationName, locale, bundle, suffixes);
    }

    public String getNotificationDescription(String notificationType, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, notificationType, new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getNotificationDescription(notificationType, locale, bundle);
    }

    public String getChildTypeDescription(String childType, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, childType, new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getChildTypeDescription(childType, locale, bundle);
    }

    public String getResourceDescription(Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getResourceDescription(locale, bundle);
    }

    public String getResourceDeprecatedDescription(Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, "deprecated", new String[0]);
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getResourceDeprecatedDescription(locale, bundle);
    }

    public String getResourceAttributeDeprecatedDescription(String attributeName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, attributeName, "deprecated");
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getResourceAttributeDeprecatedDescription(attributeName, locale, bundle);
    }

    public String getOperationDeprecatedDescription(String operationName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key = this.getBundleKey(path, operationName, "deprecated");
            if (!bundle.containsKey(key)) continue;
            return bundle.getString(key);
        }
        return super.getOperationDeprecatedDescription(operationName, locale, bundle);
    }

    public String getOperationParameterDeprecatedDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
        for (PathElement path : this.paths) {
            String key;
            String[] stringArray;
            if (this.isReuseAttributesForAdd() && operationName.equals("add")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = paramName;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = operationName;
                stringArray = stringArray3;
                stringArray3[1] = paramName;
            }
            if (!bundle.containsKey(key = this.getBundleKey(path, stringArray, "deprecated"))) continue;
            return bundle.getString(key);
        }
        return super.getOperationParameterDeprecatedDescription(operationName, paramName, locale, bundle);
    }

    private String getBundleKey(PathElement path) {
        return this.getBundleKey(path, new String[0], new String[0]);
    }

    private String getBundleKey(PathElement path, String key, String ... suffixes) {
        return this.getBundleKey(path, new String[]{key}, suffixes);
    }

    private String getBundleKey(PathElement path, String[] keys, String ... suffixes) {
        return SubsystemResourceDescriptionResolver.getBundleKey(this.subsystemName, path, keys, suffixes);
    }

    private static String getBundleKey(String subsystemName, PathElement path) {
        return SubsystemResourceDescriptionResolver.getBundleKey(subsystemName, path, new String[0], new String[0]);
    }

    private static String getBundleKey(String subsystemName, PathElement path, String[] keys, String ... suffixes) {
        String[] stringArray;
        StringBuilder builder = new StringBuilder(subsystemName);
        if (path.isWildcard()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path.getKey();
        } else {
            stringArray = path.getKeyValuePair();
        }
        for (String value : stringArray) {
            builder.append('.').append(value);
        }
        for (String key : keys) {
            builder.append('.').append(key);
        }
        for (String suffix : suffixes) {
            builder.append('.').append(suffix);
        }
        return builder.toString();
    }
}

