/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.AddIfAbsentStepHandler;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.DescribedAddStepHandler;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AddStepHandler
extends AbstractAddStepHandler
implements Registration<ManagementResourceRegistration>,
DescribedAddStepHandler {
    private final AddStepHandlerDescriptor descriptor;
    private final ResourceServiceHandler handler;

    public AddStepHandler(AddStepHandlerDescriptor descriptor) {
        this(descriptor, null);
    }

    public AddStepHandler(AddStepHandlerDescriptor descriptor, ResourceServiceHandler handler) {
        this.descriptor = descriptor;
        this.handler = handler;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && this.handler != null;
    }

    @Override
    public AddStepHandlerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress parentAddress = address.getParent();
        PathElement path = address.getLastElement();
        OperationStepHandler parentHandler = context.getRootResourceRegistration().getOperationHandler(parentAddress, "add");
        if (parentHandler instanceof DescribedAddStepHandler) {
            AddStepHandlerDescriptor parentDescriptor = (AddStepHandlerDescriptor)((DescribedAddStepHandler)parentHandler).getDescriptor();
            if (parentDescriptor.getRequiredChildren().contains(path)) {
                if (context.readResourceFromRoot(parentAddress, false).hasChild(path)) {
                    context.addStep(Util.createRemoveOperation((PathAddress)address), context.getRootResourceRegistration().getOperationHandler(address, "remove"), OperationContext.Stage.MODEL);
                    context.addStep(operation, (OperationStepHandler)this, OperationContext.Stage.MODEL);
                    return;
                }
            } else {
                Optional<PathElement> singletonPathResult = parentDescriptor.getRequiredSingletonChildren().stream().filter(requiredPath -> requiredPath.getKey().equals(path.getKey()) && !requiredPath.getValue().equals(path.getValue())).findFirst();
                if (singletonPathResult.isPresent()) {
                    PathElement singletonPath = singletonPathResult.get();
                    if (context.readResourceFromRoot(parentAddress, false).hasChild(singletonPath)) {
                        PathAddress singletonAddress = parentAddress.append(new PathElement[]{singletonPath});
                        context.addStep(Util.createRemoveOperation((PathAddress)singletonAddress), context.getRootResourceRegistration().getOperationHandler(singletonAddress, "remove"), OperationContext.Stage.MODEL);
                        context.addStep(operation, (OperationStepHandler)this, OperationContext.Stage.MODEL);
                        return;
                    }
                }
            }
        }
        super.execute(context, operation);
        if (this.requiresRuntime(context)) {
            this.descriptor.getRuntimeResourceRegistrations().forEach(registration -> context.addStep(registration, OperationContext.Stage.MODEL));
        }
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        for (OperationStepHandler operationStepHandler : this.descriptor.getOperationTranslators()) {
            operationStepHandler.execute(context, operation);
        }
        for (AttributeDefinition attributeDefinition : this.descriptor.getExtraParameters()) {
            attributeDefinition.validateOperation(operation);
        }
        Map<AttributeDefinition, AttributeTranslation> translations = this.descriptor.getAttributeTranslations();
        for (Map.Entry<AttributeDefinition, AttributeTranslation> entry : translations.entrySet()) {
            AttributeDefinition alias = entry.getKey();
            AttributeTranslation translation = entry.getValue();
            Attribute target = translation.getTargetAttribute();
            String targetName = target.getName();
            if (!operation.hasDefined(alias.getName()) || operation.hasDefined(targetName)) continue;
            ModelNode value = alias.validateOperation(operation);
            ModelNode translatedValue = translation.getWriteTranslator().translate(context, value);
            operation.get(targetName).set(translatedValue);
        }
        ModelNode modelNode = resource.getModel();
        ImmutableManagementResourceRegistration immutableManagementResourceRegistration = context.getResourceRegistration();
        for (String attributeName : immutableManagementResourceRegistration.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
            AttributeAccess attribute = immutableManagementResourceRegistration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            AttributeDefinition definition = attribute.getAttributeDefinition();
            if (attribute.getStorageType() != AttributeAccess.Storage.CONFIGURATION || translations.containsKey(definition)) continue;
            definition.validateAndSet(operation, modelNode);
        }
        AddStepHandler.addRequiredChildren(context, this.descriptor.getRequiredChildren(), (parent, path) -> parent.hasChild(path));
        AddStepHandler.addRequiredChildren(context, this.descriptor.getRequiredSingletonChildren(), (parent, path) -> parent.hasChildren(path.getKey()));
    }

    private static void addRequiredChildren(OperationContext context, Collection<PathElement> paths, BiPredicate<Resource, PathElement> present) {
        paths.forEach(path -> context.addStep(Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{path})), (OperationStepHandler)new AddIfAbsentStepHandler(present), OperationContext.Stage.MODEL));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.handler.installServices(context, model);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        try {
            this.handler.removeServices(context, resource.getModel());
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ModelNode model = resource.getModel();
        this.descriptor.getCapabilities().entrySet().stream().filter(entry -> ((Predicate)entry.getValue()).test(model)).map(Map.Entry::getKey).forEach(capability -> context.registerCapability(capability.resolve(address)));
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        registration.getAttributeNames(PathAddress.EMPTY_ADDRESS).stream().map(name -> registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, name)).filter(Objects::nonNull).map(AttributeAccess::getAttributeDefinition).filter(Objects::nonNull).filter(AttributeDefinition::hasCapabilityRequirements).forEach(attribute -> attribute.addCapabilityRequirements(context, model.get(attribute.getName())));
        this.descriptor.getResourceCapabilityReferences().forEach((reference, resolver) -> reference.addCapabilityRequirements(context, (String)null, new String[]{(String)resolver.apply(address)}));
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder("add", this.descriptor.getDescriptionResolver()).withFlag(OperationEntry.Flag.RESTART_NONE);
        if (registration.isOrderedChildResource()) {
            builder.addParameter((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"add-index", (ModelType)ModelType.INT, (boolean)true).build());
        }
        Stream<AttributeDefinition> parameters = this.descriptor.getAttributes().stream();
        parameters = Stream.concat(parameters, this.descriptor.getExtraParameters().stream());
        parameters = Stream.concat(parameters, this.descriptor.getAttributeTranslations().keySet().stream());
        parameters.forEach(attribute -> builder.addParameter(attribute));
        registration.registerOperationHandler((OperationDefinition)builder.build(), (OperationStepHandler)this);
    }
}

