/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.jboss.as.clustering.controller.ExecutionHandler;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.controller.OperationExecutor;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

public class OperationHandler<C>
extends ExecutionHandler<C, Operation<C>>
implements Registration<ManagementResourceRegistration> {
    private final Collection<? extends Operation<C>> operations;

    public <O extends Enum<O>> OperationHandler(OperationExecutor<C> executor, Class<O> operationClass) {
        this(executor, EnumSet.allOf(operationClass));
    }

    public OperationHandler(OperationExecutor<C> executor, Operation<C>[] operations) {
        this(executor, Arrays.asList(operations));
    }

    public OperationHandler(OperationExecutor<C> executor, Collection<? extends Operation<C>> operations) {
        super(executor, operations, Operation::getName, Operations::getName);
        this.operations = operations;
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        for (Operation<C> operation : this.operations) {
            registration.registerOperationHandler((OperationDefinition)operation.getDefinition(), (OperationStepHandler)this);
        }
    }
}

