/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.subsystem;

import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.controller.Schema;
import org.jboss.as.controller.Extension;
import org.jboss.as.subsystem.test.AbstractSubsystemBaseTest;

public abstract class ClusteringSubsystemTest<S extends Schema<S>>
extends AbstractSubsystemBaseTest {
    private final Schema<S> testSchema;
    private final String xmlPattern;
    private final String xsdPattern;

    protected ClusteringSubsystemTest(String name, Extension extension, Schema<S> testSchema, String xmlPattern, String xsdPattern) {
        super(name, extension);
        this.testSchema = testSchema;
        this.xmlPattern = xmlPattern;
        this.xsdPattern = xsdPattern;
    }

    protected String getSubsystemXml() throws IOException {
        return this.readResource(String.format(Locale.ROOT, this.xmlPattern, this.testSchema.major(), this.testSchema.minor()));
    }

    protected String getSubsystemXsdPath() throws Exception {
        return String.format(Locale.ROOT, this.xsdPattern, this.testSchema.major(), this.testSchema.minor());
    }

    protected void compareXml(String configId, String original, String marshalled) throws Exception {
        XMLStreamReader originalReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(original));
        XMLStreamReader marshalledReader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(marshalled));
        String originalNS = null;
        if (originalReader.next() == 1) {
            originalNS = originalReader.getNamespaceURI();
        }
        String marshalledNS = null;
        if (marshalledReader.next() == 1) {
            marshalledNS = marshalledReader.getNamespaceURI();
        }
        if (originalNS.equals(marshalledNS)) {
            this.compareXml(configId, original, marshalled, true);
        }
    }
}

