/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.spi.NodeFactory;

public class PrimaryOwnerLocator<K>
implements Function<K, Node>,
Predicate<K> {
    private final DistributionManager distribution;
    private final NodeFactory<Address> memberFactory;
    private final Group group;

    public PrimaryOwnerLocator(Cache<? extends K, ?> cache, org.wildfly.clustering.spi.group.Group<Address> group) {
        this(cache, (NodeFactory<Address>)group, (Group)group);
    }

    public PrimaryOwnerLocator(Cache<? extends K, ?> cache, NodeFactory<Address> memberFactory, Group group) {
        this.distribution = cache.getAdvancedCache().getDistributionManager();
        this.memberFactory = memberFactory;
        this.group = group;
    }

    @Override
    public Node apply(K key) {
        Address address = this.distribution != null ? this.distribution.getCacheTopology().getDistribution(key).primary() : null;
        Node node = address != null ? this.memberFactory.createNode((Object)address) : null;
        return node != null ? node : this.group.getLocalMember();
    }

    @Override
    public boolean test(K key) {
        return this.distribution != null ? this.distribution.getCacheTopology().getDistribution(key).isPrimary() : true;
    }
}

