/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan.scheduler;

import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.cache.Key;
import org.wildfly.clustering.ee.infinispan.scheduler.Scheduler;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class ScheduleLocalKeysTask<I, K extends Key<I>>
implements BiConsumer<Locality, Locality> {
    private final Cache<K, ?> cache;
    private final Predicate<? super K> filter;
    private final Scheduler<I, ?> scheduler;

    public ScheduleLocalKeysTask(Cache<K, ?> cache, Predicate<? super K> filter, Scheduler<I, ?> scheduler) {
        this.cache = cache;
        this.filter = filter;
        this.scheduler = scheduler;
    }

    @Override
    public void accept(Locality oldLocality, Locality newLocality) {
        try (CacheStream stream = this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).keySet().stream().filter(this.filter);){
            Iterator keys = stream.iterator();
            while (keys.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                Key key = (Key)keys.next();
                if (oldLocality.isLocal((Object)key) || !newLocality.isLocal((Object)key)) continue;
                this.scheduler.schedule(key.getId());
            }
        }
    }
}

