/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan.scheduler;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.CompletableFutures;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.infinispan.scheduler.Scheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.SchedulerListener;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class SchedulerTopologyChangeListener<I, K extends Key<I>, V>
implements SchedulerListener {
    private final Cache<K, V> cache;
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory(SchedulerTopologyChangeListener.class));
    private final AtomicReference<Future<?>> scheduleTaskFuture = new AtomicReference();
    private final Consumer<Locality> cancelTask;
    private final BiConsumer<Locality, Locality> scheduleTask;

    public SchedulerTopologyChangeListener(Cache<K, V> cache, Scheduler<I, ?> scheduler, BiConsumer<Locality, Locality> scheduleTask) {
        this(cache, scheduler::cancel, scheduleTask);
    }

    public SchedulerTopologyChangeListener(Cache<K, V> cache, Consumer<Locality> cancelTask, BiConsumer<Locality, Locality> scheduleTask) {
        this.cache = cache;
        this.cancelTask = cancelTask;
        this.scheduleTask = scheduleTask;
        this.cache.addListener((Object)this);
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        WildFlySecurityManager.doUnchecked((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<K, V> event) {
        Set newSegments;
        Cache cache = event.getCache();
        Address address = cache.getCacheManager().getAddress();
        ConsistentHash oldHash = event.getWriteConsistentHashAtStart();
        Set oldSegments = oldHash.getMembers().contains(address) ? oldHash.getPrimarySegmentsForOwner(address) : Collections.emptySet();
        ConsistentHash newHash = event.getWriteConsistentHashAtEnd();
        Set set = newSegments = newHash.getMembers().contains(address) ? newHash.getPrimarySegmentsForOwner(address) : Collections.emptySet();
        if (event.isPre()) {
            if (!newSegments.containsAll(oldSegments)) {
                Future future = this.scheduleTaskFuture.getAndSet(null);
                if (future != null) {
                    future.cancel(true);
                }
                return CompletableFuture.runAsync(() -> this.cancelTask.accept((Locality)new ConsistentHashLocality(cache, newHash)), this.executor);
            }
        } else if (!oldSegments.containsAll(newSegments)) {
            ConsistentHashLocality oldLocality = new ConsistentHashLocality(cache, oldHash);
            ConsistentHashLocality newLocality = new ConsistentHashLocality(cache, newHash);
            try {
                Future<?> future = this.scheduleTaskFuture.getAndSet(this.executor.submit(() -> this.lambda$topologyChanged$1((Locality)oldLocality, (Locality)newLocality)));
                if (future != null) {
                    future.cancel(true);
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return CompletableFutures.completedNull();
    }

    private /* synthetic */ void lambda$topologyChanged$1(Locality oldLocality, Locality newLocality) {
        this.scheduleTask.accept(oldLocality, newLocality);
    }
}

