/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.ActiveTransactionBatch;
import org.wildfly.clustering.ee.infinispan.InfinispanBatchContext;
import org.wildfly.clustering.ee.infinispan.NestedTransactionBatch;
import org.wildfly.clustering.ee.infinispan.NewTransactionBatch;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;

public class InfinispanBatcher
implements Batcher<TransactionBatch> {
    private static final BatchContext PASSIVE_BATCH_CONTEXT = new BatchContext(){

        public void close() {
        }
    };
    private static final TransactionBatch NON_TX_BATCH = new TransactionBatch(){

        public boolean isActive() {
            return true;
        }

        public void close() {
        }

        public void discard() {
        }

        @Override
        public Transaction getTransaction() {
            return null;
        }
    };
    private final TransactionManager tm;

    public InfinispanBatcher(Cache<?, ?> cache) {
        this(cache.getAdvancedCache().getTransactionManager());
    }

    public InfinispanBatcher(TransactionManager tm) {
        this.tm = tm;
    }

    public TransactionBatch createBatch() {
        if (this.tm == null) {
            return NON_TX_BATCH;
        }
        try {
            Transaction tx = this.tm.getTransaction();
            return tx == null ? new NewTransactionBatch(this.tm) : new NestedTransactionBatch(tx);
        }
        catch (SystemException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public BatchContext resumeBatch(TransactionBatch batch) {
        if (batch == null) {
            return PASSIVE_BATCH_CONTEXT;
        }
        try {
            Transaction tx = batch.getTransaction();
            return tx != null ? new InfinispanBatchContext(this.tm, tx) : PASSIVE_BATCH_CONTEXT;
        }
        catch (InvalidTransactionException | SystemException e) {
            throw new CacheException(e);
        }
    }

    public TransactionBatch suspendBatch() {
        if (this.tm == null) {
            return null;
        }
        try {
            Transaction tx = this.tm.suspend();
            return tx != null ? new ActiveTransactionBatch(this.tm, tx) : null;
        }
        catch (SystemException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

