/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.util.Map;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.cache.bean.ImmutableBeanGroup;

public class DefaultImmutableBeanGroup<K, V extends BeanInstance<K>>
implements ImmutableBeanGroup<K, V> {
    private final K id;
    private final Map<K, V> instances;
    private final Runnable closeTask;

    public DefaultImmutableBeanGroup(K id, Map<K, V> instances, Runnable closeTask) {
        this.id = id;
        this.instances = instances;
        this.closeTask = closeTask;
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public boolean isEmpty() {
        return this.instances.isEmpty();
    }

    @Override
    public V getBeanInstance(K id) {
        return (V)((BeanInstance)this.instances.get(id));
    }

    @Override
    public void close() {
        this.closeTask.run();
    }

    public String toString() {
        return String.format("%s { %s -> %s }", this.getClass().getSimpleName(), this.id, this.instances.keySet());
    }
}

