/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.jboss.as.clustering.controller.BuilderAdapter;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.ejb.BeanContext;
import org.wildfly.clustering.ejb.BeanManagerFactory;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderConfiguration;
import org.wildfly.clustering.ejb.BeanManagerFactoryBuilderFactory;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManager;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerFactoryBuilder;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.concurrent.CachedThreadPoolExecutorServiceBuilder;
import org.wildfly.clustering.service.concurrent.RemoveOnCancelScheduledExecutorServiceBuilder;

public class InfinispanBeanManagerFactoryBuilderFactory<I>
implements BeanManagerFactoryBuilderFactory<I, TransactionBatch> {
    private static final ThreadFactory EXPIRATION_THREAD_FACTORY = InfinispanBeanManagerFactoryBuilderFactory.createThreadFactory();
    private static final ThreadFactory EVICTION_THREAD_FACTORY = InfinispanBeanManagerFactoryBuilderFactory.createThreadFactory();
    private final CapabilityServiceSupport support;
    private final String name;
    private final BeanManagerFactoryBuilderConfiguration config;

    private static ThreadFactory createThreadFactory() {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup(InfinispanBeanManager.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
    }

    static String getCacheName(ServiceName deploymentUnitServiceName) {
        if (Services.JBOSS_DEPLOYMENT_SUB_UNIT.isParentOf(deploymentUnitServiceName)) {
            return deploymentUnitServiceName.getParent().getSimpleName() + "/" + deploymentUnitServiceName.getSimpleName();
        }
        return deploymentUnitServiceName.getSimpleName();
    }

    public InfinispanBeanManagerFactoryBuilderFactory(CapabilityServiceSupport support, String name, BeanManagerFactoryBuilderConfiguration config) {
        this.support = support;
        this.name = name;
        this.config = config;
    }

    public Collection<CapabilityServiceBuilder<?>> getDeploymentBuilders(final ServiceName name) {
        String cacheName = InfinispanBeanManagerFactoryBuilderFactory.getCacheName(name);
        String containerName = this.config.getContainerName();
        String templateCacheName = this.config.getCacheName();
        Consumer<ConfigurationBuilder> configurator = builder -> {
            MemoryConfiguration memory;
            ExpirationConfiguration expiration = builder.expiration().create();
            if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
                builder.expiration().lifespan(-1L).maxIdle(-1L);
                InfinispanEjbLogger.ROOT_LOGGER.expirationDisabled(InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, templateCacheName));
            }
            if ((memory = builder.memory().create()).size() >= 0L) {
                builder.memory().size(-1L);
                InfinispanEjbLogger.ROOT_LOGGER.evictionDisabled(InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, templateCacheName));
            }
        };
        ArrayList builders = new ArrayList(4);
        builders.add((CapabilityServiceBuilder<?>)new TemplateConfigurationBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(containerName, cacheName)), containerName, cacheName, templateCacheName, configurator));
        builders.add((CapabilityServiceBuilder<?>)new CacheBuilder<Object, Object>(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(containerName, cacheName)), containerName, cacheName){

            public ServiceBuilder<Cache<Object, Object>> build(ServiceTarget target) {
                return super.build(target).addDependency(name.append(new String[]{"marshalling"}));
            }
        });
        builders.add((CapabilityServiceBuilder<?>)new BuilderAdapter((Builder)new RemoveOnCancelScheduledExecutorServiceBuilder(name.append(new String[]{this.name, "expiration"}), EXPIRATION_THREAD_FACTORY)));
        builders.add((CapabilityServiceBuilder<?>)new BuilderAdapter((Builder)new CachedThreadPoolExecutorServiceBuilder(name.append(new String[]{this.name, "eviction"}), EVICTION_THREAD_FACTORY)));
        return builders;
    }

    public <T> Builder<? extends BeanManagerFactory<I, T, TransactionBatch>> getBeanManagerFactoryBuilder(BeanContext context) {
        return new InfinispanBeanManagerFactoryBuilder(this.support, this.name, context, this.config);
    }
}

