/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.CompositeServiceBuilder;
import org.jboss.as.clustering.controller.CompositeServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagementConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagerFactory;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCreationMetaDataKey;
import org.wildfly.clustering.ejb.timer.TimerManagerFactory;
import org.wildfly.clustering.ejb.timer.TimerManagerFactoryConfiguration;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.ejb.timer.TimerServiceConfiguration;
import org.wildfly.clustering.infinispan.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.container.DataContainerConfigurationBuilder;
import org.wildfly.clustering.infinispan.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.service.InfinispanRequirement;
import org.wildfly.clustering.infinispan.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.service.CacheServiceConfiguratorProvider;
import org.wildfly.clustering.server.service.ClusteringCacheRequirement;
import org.wildfly.clustering.server.service.ClusteringRequirement;
import org.wildfly.clustering.server.service.DistributedCacheServiceConfiguratorProvider;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class InfinispanTimerManagerFactoryServiceConfigurator<I, C>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
InfinispanTimerManagerFactoryConfiguration<I>,
Supplier<TimerManagerFactory<I, TransactionBatch>>,
Consumer<ConfigurationBuilder> {
    private final InfinispanTimerManagementConfiguration configuration;
    private final TimerManagerFactoryConfiguration<I> factoryConfiguration;
    private final boolean persistent;
    private volatile CompositeServiceConfigurator dependenciesConfigurator;
    private volatile SupplierDependency<KeyAffinityServiceFactory> affinityFactory;
    private volatile SupplierDependency<CommandDispatcherFactory> dispatcherFactory;
    private volatile SupplierDependency<Group<Address>> group;
    private volatile Supplier<Cache> cache;

    public InfinispanTimerManagerFactoryServiceConfigurator(InfinispanTimerManagementConfiguration configuration, TimerManagerFactoryConfiguration<I> factoryConfiguration) {
        super(ServiceName.JBOSS.append(new String[]{"clustering", "timer"}).append(new String[]{factoryConfiguration.getTimerServiceConfiguration().getName()}));
        this.configuration = configuration;
        this.factoryConfiguration = factoryConfiguration;
        this.persistent = factoryConfiguration.isPersistent();
    }

    @Override
    public TimerManagerFactory<I, TransactionBatch> get() {
        return new InfinispanTimerManagerFactory(this);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        String containerName = this.configuration.getContainerName();
        String cacheName = this.configuration.getCacheName();
        String beanName = this.factoryConfiguration.getTimerServiceConfiguration().getName();
        ServiceName cacheServiceName = InfinispanCacheRequirement.CACHE.getServiceName(support, containerName, beanName);
        this.dependenciesConfigurator = new CompositeServiceConfigurator(cacheServiceName);
        this.dependenciesConfigurator.accept(new TemplateConfigurationServiceConfigurator(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, containerName, beanName), containerName, beanName, cacheName, (Consumer)this).configure(support));
        this.dependenciesConfigurator.accept(new CacheServiceConfigurator(cacheServiceName, containerName, beanName).configure(support));
        for (CacheServiceConfiguratorProvider cacheServiceConfiguratorProvider : ServiceLoader.load(DistributedCacheServiceConfiguratorProvider.class, DistributedCacheServiceConfiguratorProvider.class.getClassLoader())) {
            for (ServiceConfigurator configurator : cacheServiceConfiguratorProvider.getServiceConfigurators(support, this.configuration.getContainerName(), beanName)) {
                this.dependenciesConfigurator.accept(configurator);
            }
        }
        this.affinityFactory = new ServiceSupplierDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, containerName));
        this.dispatcherFactory = new ServiceSupplierDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, containerName));
        this.group = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, containerName, beanName));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer consumer = new CompositeDependency(new Dependency[]{this.affinityFactory, this.dispatcherFactory, this.group}).register(builder).provides(new ServiceName[]{name});
        this.cache = builder.requires(this.dependenciesConfigurator.getServiceName());
        builder.setInstance((Service)new FunctionalService(consumer, Function.identity(), (Supplier)this)).setInitialMode(ServiceController.Mode.ON_DEMAND);
        return new CompositeServiceBuilder(List.of(this.dependenciesConfigurator.build(target), builder));
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        Integer size;
        ExpirationConfiguration expiration = builder.expiration().create();
        if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
            builder.expiration().lifespan(-1L).maxIdle(-1L);
        }
        EvictionStrategy strategy = (size = this.configuration.getMaxActiveTimers()) != null ? EvictionStrategy.REMOVE : EvictionStrategy.NONE;
        builder.memory().storage(StorageType.HEAP).whenFull(strategy).maxCount(size != null ? size.longValue() : 0L);
        if (strategy.isEnabled()) {
            ((DataContainerConfigurationBuilder)builder.addModule(DataContainerConfigurationBuilder.class)).evictable(TimerCreationMetaDataKey.class::isInstance);
        }
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup(() -> EmbeddedTransactionManager.getInstance()).lockingMode(LockingMode.PESSIMISTIC).locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        builder.persistence().passivation(false);
    }

    public TimerServiceConfiguration getTimerServiceConfiguration() {
        return this.factoryConfiguration.getTimerServiceConfiguration();
    }

    public Supplier<I> getIdentifierFactory() {
        return this.factoryConfiguration.getIdentifierFactory();
    }

    @Override
    public ByteBufferMarshaller getMarshaller() {
        return (ByteBufferMarshaller)this.configuration.getMarshallerFactory().apply(this.factoryConfiguration.getTimerServiceConfiguration().getModule());
    }

    public <K, V> Cache<K, V> getCache() {
        return this.cache.get();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.get();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.get();
    }

    @Override
    public Group<Address> getGroup() {
        return (Group)this.group.get();
    }

    public TimerRegistry<I> getRegistry() {
        return this.factoryConfiguration.getRegistry();
    }

    public boolean isPersistent() {
        return this.persistent;
    }
}

