/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.infinispan.Cache;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.listener.ListenerRegistration;
import org.wildfly.clustering.cache.infinispan.embedded.listener.PostActivateBlockingListener;
import org.wildfly.clustering.cache.infinispan.embedded.listener.PrePassivateBlockingListener;
import org.wildfly.clustering.ejb.bean.BeanInstance;
import org.wildfly.clustering.ejb.cache.bean.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.marshalling.MarshalledValue;
import org.wildfly.clustering.server.Registration;

public class InfinispanBeanGroupListener<K, V extends BeanInstance<K>, C>
implements Registration {
    private final Cache<Key<K>, ?> cache;
    private final C context;
    private final Executor executor;
    private final ListenerRegistration postActivateListenerRegistration;
    private final ListenerRegistration prePassivateListenerRegistration;

    public InfinispanBeanGroupListener(EmbeddedCacheConfiguration configuration, C context) {
        this.cache = configuration.getCache();
        this.context = context;
        this.executor = !configuration.getCacheProperties().isPersistent() ? configuration.getExecutor() : null;
        this.postActivateListenerRegistration = this.executor != null ? new PostActivateBlockingListener(configuration.getCache(), this::postActivate).register(BeanGroupKey.class) : null;
        this.prePassivateListenerRegistration = this.executor != null ? new PrePassivateBlockingListener(configuration.getCache(), this::prePassivate).register(BeanGroupKey.class) : null;
    }

    public void close() {
        Optional.ofNullable(this.postActivateListenerRegistration).ifPresent((java.util.function.Consumer<ListenerRegistration>)Consumer.close());
        Optional.ofNullable(this.prePassivateListenerRegistration).ifPresent((java.util.function.Consumer<ListenerRegistration>)Consumer.close());
    }

    void postActivate(BeanGroupKey<K> key, MarshalledValue<Map<K, V>, C> value) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Received post-activate event for bean group %s", key.getId());
        try {
            Map instances = (Map)value.get(this.context);
            for (BeanInstance instance : instances.values()) {
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Invoking post-activate callback for bean %s", instance.getId());
                instance.postActivate();
            }
        }
        catch (IOException e) {
            InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
        }
    }

    void prePassivate(BeanGroupKey<K> key, MarshalledValue<Map<K, V>, C> value) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Received pre-passivate event for bean group %s", key.getId());
        try {
            Map instances = (Map)value.get(this.context);
            ArrayList<BeanInstance> passivated = new ArrayList<BeanInstance>(instances.size());
            try {
                for (BeanInstance instance : instances.values()) {
                    Object id = instance.getId();
                    InfinispanEjbLogger.ROOT_LOGGER.tracef("Invoking pre-passivate callback for bean %s", id);
                    instance.prePassivate();
                    passivated.add(instance);
                    this.executor.execute(() -> this.cache.evict(new InfinispanBeanMetaDataKey<Object>(id)));
                }
            }
            catch (Error | RuntimeException e) {
                for (BeanInstance instance : passivated) {
                    InfinispanEjbLogger.ROOT_LOGGER.tracef("Invoking post-activate callback for bean %s", instance.getId());
                    try {
                        instance.postActivate();
                    }
                    catch (Error | RuntimeException t) {
                        InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                    }
                }
                throw e;
            }
        }
        catch (IOException e) {
            InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
        }
    }
}

