/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.service;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.wildfly.clustering.infinispan.service.ConfigurationServiceInstallerFactory;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.common.function.Functions;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class TemplateConfigurationServiceInstallerFactory
implements BiFunction<BinaryServiceConfiguration, BinaryServiceConfiguration, ServiceInstaller> {
    private final Consumer<ConfigurationBuilder> configurator;

    public TemplateConfigurationServiceInstallerFactory() {
        this(Functions.discardingConsumer());
    }

    public TemplateConfigurationServiceInstallerFactory(Consumer<ConfigurationBuilder> configurator) {
        this.configurator = configurator;
    }

    @Override
    public ServiceInstaller apply(BinaryServiceConfiguration templateConfiguration, BinaryServiceConfiguration configuration) {
        final ServiceDependency template = templateConfiguration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONFIGURATION);
        Consumer<ConfigurationBuilder> configurator = new Consumer<ConfigurationBuilder>(){

            @Override
            public void accept(ConfigurationBuilder builder) {
                builder.read((Configuration)template.get());
            }
        };
        return new ConfigurationServiceInstallerFactory(configurator.andThen(this.configurator), List.of(template)).apply(configuration);
    }
}

