/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.service;

import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.suspend.ServerResumeContext;
import org.jboss.as.server.suspend.ServerSuspendContext;
import org.jboss.as.server.suspend.SuspendableActivity;
import org.jboss.as.server.suspend.SuspendableActivityRegistry;
import org.jboss.as.server.suspend.SuspensionStateProvider;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CacheServiceInstaller
implements ServiceInstaller {
    private static final Logger LOGGER = Logger.getLogger(CacheServiceInstaller.class);
    private final BinaryServiceConfiguration configuration;

    public CacheServiceInstaller(BinaryServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    public ServiceController<?> install(RequirementServiceTarget target) {
        final ServiceDependency container = this.configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONTAINER);
        final ServiceDependency cacheConfiguration = this.configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONFIGURATION);
        final ServiceDependency activityRegistry = ServiceDependency.on((NullaryServiceDescriptor)SuspendableActivityRegistry.SERVICE_DESCRIPTOR);
        final ServiceDependency processStateProvider = ServiceDependency.on((NullaryServiceDescriptor)ProcessStateNotifier.SERVICE_DESCRIPTOR);
        final ServiceDependency environment = ServiceDependency.on((NullaryServiceDescriptor)ServerEnvironment.SERVICE_DESCRIPTOR);
        final String cacheName = this.configuration.getChildName();
        Supplier cache = new Supplier<Cache<?, ?>>(){

            @Override
            public Cache<?, ?> get() {
                ControlledProcessState.State state;
                Configuration suspendedConfiguration;
                EmbeddedCacheManager manager = (EmbeddedCacheManager)container.get();
                Configuration originalConfiguration = (Configuration)cacheConfiguration.get();
                SuspendableActivityRegistry registry = (SuspendableActivityRegistry)activityRegistry.get();
                Configuration configuration = suspendedConfiguration = originalConfiguration.clustering().cacheMode().isDistributed() ? new ConfigurationBuilder().read(originalConfiguration).clustering().hash().capacityFactor(Float.MIN_VALUE).build() : originalConfiguration;
                if (suspendedConfiguration != originalConfiguration && registry.getState() != SuspensionStateProvider.State.RUNNING && ((state = ((ProcessStateNotifier)processStateProvider.get()).getCurrentState()) == ControlledProcessState.State.RUNNING || state == ControlledProcessState.State.STARTING && ((ServerEnvironment)environment.get()).isStartSuspended())) {
                    LOGGER.debugf("%s cache of %s container will start using a suspended configuration", (Object)cacheName, (Object)manager.getCacheManagerConfiguration().cacheManagerName());
                    manager.undefineConfiguration(cacheName);
                    manager.defineConfiguration(cacheName, suspendedConfiguration);
                }
                return new DefaultCache(manager.getCache(cacheName), originalConfiguration, suspendedConfiguration, registry);
            }
        };
        return ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(ManagedCache::new, (Supplier)cache).blocking()).provides(this.configuration.resolveServiceName(InfinispanServiceDescriptor.CACHE))).requires(List.of(container, cacheConfiguration, activityRegistry, processStateProvider, environment))).onStart(Lifecycle::start)).onStop(Cache::stop)).build()).install((ServiceTarget)target);
    }

    private static class ManagedCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        ManagedCache(Cache<K, V> cache) {
            this(cache.getAdvancedCache());
        }

        private ManagedCache(AdvancedCache<K, V> cache) {
            super(cache);
        }

        public AdvancedCache rewrap(AdvancedCache delegate) {
            return new ManagedCache<K, V>(delegate);
        }

        public void start() {
        }

        public void stop() {
        }
    }

    private static class DefaultCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        private final SuspendableActivityRegistry activityRegistry;
        private final SuspendableActivity activity;

        DefaultCache(final Cache<K, V> cache, final Configuration resumedConfiguration, final Configuration suspendedConfiguration, SuspendableActivityRegistry activityRegistry) {
            this(cache.getAdvancedCache(), activityRegistry, new SuspendableActivity(){
                private final BlockingManager blocking;
                {
                    this.blocking = (BlockingManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)cache.getCacheManager(), BlockingManager.class);
                }

                public CompletionStage<Void> suspend(ServerSuspendContext context) {
                    if (context.isStarting() || context.isStopping() || resumedConfiguration == suspendedConfiguration || cache.getCacheConfiguration().clustering().hash().capacityFactor() == suspendedConfiguration.clustering().hash().capacityFactor() || cache.getAdvancedCache().getDistributionManager().getCacheTopology().getActualMembers().size() < 2) {
                        return SuspendableActivity.COMPLETED;
                    }
                    return this.blocking.runBlocking(new Runnable(){

                        @Override
                        public void run() {
                            LOGGER.debugf("Restarting %s cache of %s container using suspended configuration", (Object)cache.getName(), (Object)cache.getCacheManager().getCacheManagerConfiguration().cacheManagerName());
                            ((BasicComponentRegistry)ComponentRegistry.componentOf((Cache)cache, BasicComponentRegistry.class)).replaceComponent(Installer.Configuration.class.getName(), (Object)suspendedConfiguration, false);
                            cache.stop();
                            cache.start();
                        }
                    }, (Object)"suspend");
                }

                public CompletionStage<Void> resume(ServerResumeContext context) {
                    if (context.isStarting() || resumedConfiguration == suspendedConfiguration || cache.getCacheConfiguration().clustering().hash().capacityFactor() == resumedConfiguration.clustering().hash().capacityFactor()) {
                        return SuspendableActivity.COMPLETED;
                    }
                    return this.blocking.runBlocking(new Runnable(){

                        @Override
                        public void run() {
                            LOGGER.debugf("Restarting %s cache of %s container using original configuration", (Object)cache.getName(), (Object)cache.getCacheManager().getCacheManagerConfiguration().cacheManagerName());
                            ((BasicComponentRegistry)ComponentRegistry.componentOf((Cache)cache, BasicComponentRegistry.class)).replaceComponent(Installer.Configuration.class.getName(), (Object)resumedConfiguration, false);
                            cache.stop();
                            cache.start();
                        }
                    }, (Object)"resume");
                }
            });
        }

        private DefaultCache(AdvancedCache<K, V> cache, SuspendableActivityRegistry activityRegistry, SuspendableActivity activity) {
            super(cache.getAdvancedCache());
            this.activityRegistry = activityRegistry;
            this.activity = activity;
        }

        public AdvancedCache rewrap(AdvancedCache delegate) {
            return new DefaultCache<K, V>(delegate, this.activityRegistry, this.activity);
        }

        public void start() {
            this.activityRegistry.registerActivity(this.activity, SuspendableActivityRegistry.SuspendPriority.LAST);
            super.start();
        }

        public void stop() {
            super.stop();
            this.activityRegistry.unregisterActivity(this.activity);
        }
    }
}

