/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshall;

import org.infinispan.commons.dataconversion.BinaryTranscoder;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.DefaultTranscoder;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.GlobalMarshallerEncoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.TranscoderMarshallerAdapter;
import org.infinispan.commons.dataconversion.UTF8Encoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.encoding.ProtostreamTranscoder;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.wildfly.clustering.infinispan.marshall.DefaultEncoderRegistry;

@DefaultFactoryFor(classes={EncoderRegistry.class})
public class EncoderRegistryFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    @Inject
    @ComponentName(value="org.infinispan.marshaller.internal")
    ComponentRef<Marshaller> internalMarshaller;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.user")
    Marshaller marshaller;
    @Inject
    EmbeddedCacheManager manager;
    @Inject
    SerializationContextRegistry ctxRegistry;

    public Object construct(String componentName) {
        ClassLoader classLoader = this.globalConfiguration.classLoader();
        DefaultEncoderRegistry encoderRegistry = new DefaultEncoderRegistry();
        encoderRegistry.registerEncoder((Encoder)IdentityEncoder.INSTANCE);
        encoderRegistry.registerEncoder((Encoder)UTF8Encoder.INSTANCE);
        encoderRegistry.registerEncoder((Encoder)new GlobalMarshallerEncoder((Marshaller)this.internalMarshaller.wired()));
        encoderRegistry.registerTranscoder((Transcoder)new DefaultTranscoder(this.marshaller));
        encoderRegistry.registerTranscoder((Transcoder)new BinaryTranscoder(this.marshaller));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamTranscoder(this.ctxRegistry, classLoader));
        encoderRegistry.registerTranscoder((Transcoder)new TranscoderMarshallerAdapter((Marshaller)this.internalMarshaller.wired()));
        encoderRegistry.registerTranscoder((Transcoder)new TranscoderMarshallerAdapter(this.marshaller));
        encoderRegistry.registerWrapper((Wrapper)ByteArrayWrapper.INSTANCE);
        encoderRegistry.registerWrapper((Wrapper)IdentityWrapper.INSTANCE);
        return encoderRegistry;
    }
}

