/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.Set;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYCLINF", length=4)
public interface InfinispanLogger
extends BasicLogger {
    public static final String ROOT_LOGGER_CATEGORY = "org.jboss.as.clustering.infinispan";
    public static final InfinispanLogger ROOT_LOGGER = (InfinispanLogger)Logger.getMessageLogger(InfinispanLogger.class, (String)"org.jboss.as.clustering.infinispan");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating Infinispan subsystem.")
    public void activatingSubsystem();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Started %s cache from %s container")
    public void cacheStarted(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Stopped %s cache from %s container")
    public void cacheStopped(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="The '%s' attribute of the '%s' element is no longer supported and will be ignored")
    public void attributeDeprecated(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="The '%s' attribute specified on the 'transport' element of a cache container is no longer valid; use the same attribute specified on the 'transport' element of corresponding JGroups stack instead")
    public void topologyAttributeDeprecated(String var1);

    @Message(id=6, value="Failed to locate a data source bound to %s")
    public OperationFailedException dataSourceJndiNameNotFound(String var1);

    @Message(id=7, value="Failed to locate data source %s")
    public OperationFailedException dataSourceNotFound(String var1);

    @Message(id=10, value="%s is not a valid cache store")
    public IllegalArgumentException invalidCacheStore(@Cause Throwable var1, String var2);

    @Message(id=27, value="Could not determine 'stack' attribute from JGroups subsystem")
    public String indeterminiteStack();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=28, value="Executor configuration '%s' was deprecated and will only be used to support legacy slaves in the domain.")
    public void executorIgnored(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="Started remote cache container '%s'.")
    public void remoteCacheContainerStarted(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=30, value="Stopped remote cache container '%s'.")
    public void remoteCacheContainerStopped(String var1);

    @Message(id=31, value="Specified HotRod protocol version %s does not support creating caches automatically. Cache named '%s' must be already created on the Infinispan Server!")
    public HotRodClientException remoteCacheMustBeDefined(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=32, value="Getting remote cache named '%s'. If it does not exist a new cache will be created from configuration template named '%s'; null value uses default cache configuration on the Infinispan Server.")
    public void remoteCacheCreated(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=33, value="Attribute '%s' is configured to use a deprecated value: %s; use one of the following values instead: %s")
    public void marshallerEnumValueDeprecated(String var1, Object var2, Set<?> var3);
}

