/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.JdkLoggerFactory;
import java.util.EnumSet;
import org.jboss.as.clustering.controller.ContextualSubsystemRegistration;
import org.jboss.as.clustering.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSchema;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemXMLReader;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemXMLWriter;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class InfinispanExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "infinispan";
    public static final SubsystemResourceDescriptionResolver SUBSYSTEM_RESOLVER = new SubsystemResourceDescriptionResolver("infinispan", InfinispanExtension.class);

    public void initialize(ExtensionContext context) {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)JdkLoggerFactory.INSTANCE);
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, InfinispanModel.CURRENT.getVersion());
        new InfinispanSubsystemResourceDefinition().register((org.jboss.as.clustering.controller.SubsystemRegistration)new ContextualSubsystemRegistration(registration, context));
        registration.registerXMLElementWriter((XMLElementWriter)new InfinispanSubsystemXMLWriter());
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (InfinispanSchema schema : EnumSet.allOf(InfinispanSchema.class)) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new InfinispanSubsystemXMLReader(schema));
        }
    }
}

