/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;

public class BackupsResourceDefinition
extends ComponentResourceDefinition {
    static final PathElement PATH = BackupsResourceDefinition.pathElement("backups");
    static final BinaryServiceDescriptor<SitesConfiguration> SERVICE_DESCRIPTOR = BackupsResourceDefinition.serviceDescriptor(PATH, SitesConfiguration.class);
    private static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GRANDPARENT_PARENT).build();
    private final FunctionExecutorRegistry<Cache<?, ?>> executors;

    public BackupsResourceDefinition(FunctionExecutorRegistry<Cache<?, ?>> executors) {
        super(PATH);
        this.executors = executors;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver());
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new BackupResourceDefinition(handler, this.executors).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        SitesConfigurationBuilder builder = new ConfigurationBuilder().sites();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        for (Resource.ResourceEntry entry : resource.getChildren(BackupResourceDefinition.WILDCARD_PATH.getKey())) {
            String siteName = entry.getName();
            ModelNode backup = entry.getModel();
            builder.addBackup().site(siteName).backupFailurePolicy(BackupFailurePolicy.valueOf((String)BackupResourceDefinition.Attribute.FAILURE_POLICY.resolveModelAttribute((ExpressionResolver)context, backup).asString())).replicationTimeout(BackupResourceDefinition.Attribute.TIMEOUT.resolveModelAttribute((ExpressionResolver)context, backup).asLong()).strategy(BackupConfiguration.BackupStrategy.valueOf((String)BackupResourceDefinition.Attribute.STRATEGY.resolveModelAttribute((ExpressionResolver)context, backup).asString())).takeOffline().afterFailures(BackupResourceDefinition.TakeOfflineAttribute.AFTER_FAILURES.resolveModelAttribute((ExpressionResolver)context, backup).asInt()).minTimeToWait(BackupResourceDefinition.TakeOfflineAttribute.MIN_WAIT.resolveModelAttribute((ExpressionResolver)context, backup).asLong());
        }
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(CAPABILITY, (Object)builder.create()).build();
    }
}

